/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Source;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class GotoTargetsArguments
extends JSONBase {
    GotoTargetsArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public Source getSource() {
        return new Source(this.jsonData.getJSONObject("source"));
    }

    public GotoTargetsArguments setSource(Source source) {
        this.jsonData.put("source", source.jsonData);
        return this;
    }

    public int getLine() {
        return this.jsonData.getInt("line");
    }

    public GotoTargetsArguments setLine(int line) {
        this.jsonData.put("line", line);
        return this;
    }

    public Integer getColumn() {
        return this.jsonData.has("column") ? Integer.valueOf(this.jsonData.getInt("column")) : null;
    }

    public GotoTargetsArguments setColumn(Integer column) {
        this.jsonData.putOpt("column", column);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GotoTargetsArguments other = (GotoTargetsArguments)obj;
        if (!Objects.equals(this.getSource(), other.getSource())) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        return Objects.equals(this.getColumn(), other.getColumn());
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.getSource());
        hash = 59 * hash + Integer.hashCode(this.getLine());
        if (this.getColumn() != null) {
            hash = 59 * hash + Integer.hashCode(this.getColumn());
        }
        return hash;
    }

    public static GotoTargetsArguments create(Source source, Integer line) {
        JSONObject json = new JSONObject();
        json.put("source", source.jsonData);
        json.put("line", line);
        return new GotoTargetsArguments(json);
    }
}

