/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.polyglot;

import com.oracle.truffle.espresso.polyglot.Interop;
import com.oracle.truffle.espresso.polyglot.InteropException;
import com.oracle.truffle.espresso.polyglot.UnsupportedMessageException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;

public final class UnknownKeyException
extends InteropException {
    private final Object unknownKey;

    private UnknownKeyException(Object unknownKey) {
        super((String)null);
        this.unknownKey = unknownKey;
    }

    private UnknownKeyException(Object unknownKey, Throwable cause) {
        super(null, cause);
        this.unknownKey = unknownKey;
    }

    @Override
    public String getMessage() {
        try {
            return "Unknown identifier: " + Interop.asString(Interop.toDisplayString(this.unknownKey, false));
        }
        catch (UnsupportedMessageException e) {
            throw new AssertionError("shouldNotReachHere", e);
        }
    }

    public Object getUnknownKey() {
        return this.unknownKey;
    }

    public static UnknownKeyException create(Object unknownKey) {
        return new UnknownKeyException(unknownKey);
    }

    public static UnknownKeyException create(Object unknownKey, Throwable cause) {
        return new UnknownKeyException(unknownKey, cause);
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        throw new NotSerializableException(UnknownKeyException.class.getSimpleName() + " serialization is not supported.");
    }
}

