/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.polyglot.collections;

import com.oracle.truffle.espresso.polyglot.Interop;
import com.oracle.truffle.espresso.polyglot.InteropException;
import com.oracle.truffle.espresso.polyglot.Polyglot;
import com.oracle.truffle.espresso.polyglot.UnsupportedMessageException;
import java.util.AbstractList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class EspressoForeignList<T>
extends AbstractList<T>
implements List<T> {
    @Override
    public int size() {
        try {
            return (int)Interop.getArraySize(this);
        }
        catch (UnsupportedMessageException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean add(T t) {
        int size = this.size();
        if (Interop.isArrayElementWritable(this, size)) {
            try {
                Interop.writeArrayElement(this, size, t);
                return true;
            }
            catch (InteropException e) {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        Objects.checkIndex(index, this.size());
        try {
            if (Interop.isArrayElementReadable(this, index)) {
                return (T)Polyglot.cast(Object.class, Interop.readArrayElement(this, index));
            }
            throw new UnsupportedOperationException();
        }
        catch (InteropException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public T set(int index, T element) {
        Objects.checkIndex(index, this.size() + 1);
        if (Interop.isArrayElementWritable(this, index)) {
            try {
                T previous = this.get(index);
                Interop.writeArrayElement(this, index, element);
                return previous;
            }
            catch (InteropException e) {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        Objects.checkIndex(index, this.size() + 1);
        try {
            long size = Interop.getArraySize(this);
            if (Interop.isArrayElementInsertable(this, size)) {
                for (long cur = size; cur > (long)index; --cur) {
                    Object o = Polyglot.cast(Object.class, Interop.readArrayElement(this, cur - 1L));
                    Interop.writeArrayElement(this, cur, o);
                }
                Interop.writeArrayElement(this, index, element);
                return;
            }
            throw new UnsupportedOperationException();
        }
        catch (InteropException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public T remove(int index) {
        Objects.checkIndex(index, this.size());
        if (Interop.isArrayElementRemovable(this, index)) {
            try {
                T previous = this.get(index);
                Interop.removeArrayElement(this, index);
                return previous;
            }
            catch (InteropException e) {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        try {
            return Interop.asString(Interop.toDisplayString(this));
        }
        catch (UnsupportedMessageException e) {
            return super.toString();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<T> {
        int cursor = 0;
        int lastRet = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != EspressoForeignList.this.size();
        }

        @Override
        public T next() {
            try {
                int i = this.cursor;
                Object next = EspressoForeignList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new UnsupportedOperationException();
            }
            try {
                EspressoForeignList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

