/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.polyglot.collections;

import com.oracle.truffle.espresso.polyglot.Interop;
import com.oracle.truffle.espresso.polyglot.InteropException;
import com.oracle.truffle.espresso.polyglot.UnsupportedMessageException;
import com.oracle.truffle.espresso.polyglot.collections.EspressoForeignIterable;
import com.oracle.truffle.espresso.polyglot.collections.EspressoForeignIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class EspressoForeignCollection<T>
extends AbstractCollection<T>
implements Collection<T> {
    @Override
    public Iterator<T> iterator() {
        assert (Interop.hasIterator(this));
        try {
            return EspressoForeignIterator.create(Interop.getIterator(this));
        }
        catch (UnsupportedMessageException e) {
            return EspressoForeignIterable.EMPTY_ITERATOR;
        }
    }

    @Override
    public int size() {
        Iterator<T> it = this.iterator();
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public boolean add(T t) {
        try {
            return Interop.asBoolean(Interop.invokeMember(this, "add", t));
        }
        catch (InteropException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean remove(Object o) {
        try {
            return Interop.asBoolean(Interop.invokeMember(this, "remove", o));
        }
        catch (InteropException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object obj : c) {
            if (!this.remove(obj)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public String toString() {
        try {
            return Interop.asString(Interop.toDisplayString(this));
        }
        catch (UnsupportedMessageException e) {
            return super.toString();
        }
    }
}

