/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.polyglot.collections;

import com.oracle.truffle.espresso.polyglot.Interop;
import com.oracle.truffle.espresso.polyglot.InteropException;
import com.oracle.truffle.espresso.polyglot.Polyglot;
import com.oracle.truffle.espresso.polyglot.UnknownKeyException;
import com.oracle.truffle.espresso.polyglot.UnsupportedMessageException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class EspressoForeignMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    @Override
    public String toString() {
        try {
            return Interop.asString(Interop.toDisplayString(this));
        }
        catch (UnsupportedMessageException e) {
            return super.toString();
        }
    }

    @Override
    public int size() {
        try {
            return (int)Interop.getHashSize(this);
        }
        catch (InteropException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return Interop.isHashEntryReadable(this, key);
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            Object hashValues = Interop.getHashValuesIterator(this);
            while (Interop.hasIteratorNextElement(hashValues)) {
                Object next = Polyglot.cast(Object.class, Interop.getIteratorNextElement(hashValues));
                if (!value.equals(next)) continue;
                return true;
            }
            return false;
        }
        catch (InteropException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public V get(Object key) {
        try {
            return (V)Polyglot.cast(Object.class, Interop.readHashValue(this, key));
        }
        catch (UnknownKeyException e) {
            return null;
        }
        catch (InteropException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public V put(K key, V value) {
        try {
            if (Interop.isHashEntryWritable(this, key)) {
                V previous = this.get(key);
                Interop.writeHashEntry(this, key, value);
                return previous;
            }
            throw new UnsupportedOperationException();
        }
        catch (InteropException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public V remove(Object key) {
        if (Interop.isHashEntryRemovable(this, key)) {
            try {
                V previous = this.get(key);
                Interop.removeHashEntry(this, key);
                return previous;
            }
            catch (InteropException e) {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        for (K k : this.keySet()) {
            this.remove(k);
        }
    }

    @Override
    public Set<K> keySet() {
        return new KeySetImpl();
    }

    @Override
    public Collection<V> values() {
        return new ValuesImpl();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new HashEntries();
    }

    private final class KeySetImpl
    extends AbstractSet<K> {
        private KeySetImpl() {
        }

        @Override
        public Iterator<K> iterator() {
            try {
                return new KeysItr(Interop.getHashKeysIterator(EspressoForeignMap.this));
            }
            catch (UnsupportedMessageException e) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public int size() {
            try {
                return (int)Interop.getHashSize(EspressoForeignMap.this);
            }
            catch (UnsupportedMessageException e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private final class ValuesImpl
    extends AbstractSet<V> {
        private ValuesImpl() {
        }

        @Override
        public Iterator<V> iterator() {
            try {
                return new ValuesItr(Interop.getHashValuesIterator(EspressoForeignMap.this));
            }
            catch (UnsupportedMessageException e) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public int size() {
            try {
                return (int)Interop.getHashSize(EspressoForeignMap.this);
            }
            catch (UnsupportedMessageException e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private final class HashEntries
    extends AbstractSet<Map.Entry<K, V>> {
        private HashEntries() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            try {
                return new EntryItr(Interop.getHashEntriesIterator(EspressoForeignMap.this));
            }
            catch (UnsupportedMessageException e) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public int size() {
            try {
                return (int)Interop.getHashSize(EspressoForeignMap.this);
            }
            catch (UnsupportedMessageException e) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private final class EspressoForeignEntry
    implements Map.Entry<K, V> {
        private final Object entry;

        private EspressoForeignEntry(Object entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            try {
                return Polyglot.cast(Object.class, Interop.readArrayElement(this.entry, 0L));
            }
            catch (InteropException e) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public V getValue() {
            try {
                return Polyglot.cast(Object.class, Interop.readArrayElement(this.entry, 1L));
            }
            catch (InteropException e) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private final class EntryItr
    implements Iterator<Map.Entry<K, V>> {
        private final Object entriesIterator;

        private EntryItr(Object entriesIterator) {
            this.entriesIterator = entriesIterator;
        }

        @Override
        public boolean hasNext() {
            try {
                return Interop.hasIteratorNextElement(this.entriesIterator);
            }
            catch (UnsupportedMessageException e) {
                return false;
            }
        }

        @Override
        public Map.Entry<K, V> next() {
            try {
                return new EspressoForeignEntry(Interop.getIteratorNextElement(this.entriesIterator));
            }
            catch (InteropException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ValuesItr
    implements Iterator<V> {
        private final Object valuesIterator;

        private ValuesItr(Object valuesIterator) {
            this.valuesIterator = valuesIterator;
        }

        @Override
        public boolean hasNext() {
            try {
                return Interop.hasIteratorNextElement(this.valuesIterator);
            }
            catch (UnsupportedMessageException e) {
                return false;
            }
        }

        @Override
        public V next() {
            try {
                return Polyglot.cast(Object.class, Interop.getIteratorNextElement(this.valuesIterator));
            }
            catch (InteropException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysItr
    implements Iterator<K> {
        private final Object keysIterator;

        private KeysItr(Object keysIterator) {
            this.keysIterator = keysIterator;
        }

        @Override
        public boolean hasNext() {
            try {
                return Interop.hasIteratorNextElement(this.keysIterator);
            }
            catch (UnsupportedMessageException e) {
                return false;
            }
        }

        @Override
        public K next() {
            try {
                return Polyglot.cast(Object.class, Interop.getIteratorNextElement(this.keysIterator));
            }
            catch (InteropException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

