/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.polyglot.collections;

import com.oracle.truffle.espresso.polyglot.Interop;
import com.oracle.truffle.espresso.polyglot.InteropException;
import com.oracle.truffle.espresso.polyglot.Polyglot;
import com.oracle.truffle.espresso.polyglot.UnsupportedMessageException;
import java.util.AbstractList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class EspressoForeignList<T>
extends AbstractList<T>
implements List<T> {
    protected Object foreignObject;

    @Override
    public int size() {
        try {
            return (int)Interop.getArraySize(this.foreignObject);
        }
        catch (UnsupportedMessageException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean add(T t) {
        int size = this.size();
        if (Interop.isArrayElementWritable(this.foreignObject, size)) {
            try {
                Interop.writeArrayElement(this.foreignObject, size, t);
                ++this.modCount;
                return true;
            }
            catch (InteropException e) {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        Objects.checkIndex(index, this.size());
        try {
            if (Interop.isArrayElementReadable(this.foreignObject, index)) {
                return (T)Polyglot.cast(Object.class, Interop.readArrayElement(this.foreignObject, index));
            }
            throw new UnsupportedOperationException();
        }
        catch (InteropException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public T set(int index, T element) {
        Objects.checkIndex(index, this.size() + 1);
        if (Interop.isArrayElementWritable(this.foreignObject, index)) {
            try {
                T previous = this.get(index);
                Interop.writeArrayElement(this.foreignObject, index, element);
                ++this.modCount;
                return previous;
            }
            catch (InteropException e) {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        Objects.checkIndex(index, this.size() + 1);
        try {
            long size = Interop.getArraySize(this.foreignObject);
            if (Interop.isArrayElementInsertable(this.foreignObject, size)) {
                for (long cur = size; cur > (long)index; --cur) {
                    Object o = Polyglot.cast(Object.class, Interop.readArrayElement(this.foreignObject, cur - 1L));
                    Interop.writeArrayElement(this.foreignObject, cur, o);
                }
                Interop.writeArrayElement(this.foreignObject, index, element);
                ++this.modCount;
                return;
            }
            throw new UnsupportedOperationException();
        }
        catch (InteropException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public T remove(int index) {
        Objects.checkIndex(index, this.size());
        if (Interop.isArrayElementRemovable(this.foreignObject, index)) {
            try {
                T previous = this.get(index);
                Interop.removeArrayElement(this.foreignObject, index);
                ++this.modCount;
                return previous;
            }
            catch (InteropException e) {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        try {
            return Interop.asString(Interop.toDisplayString(this.foreignObject));
        }
        catch (UnsupportedMessageException e) {
            return super.toString();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    static /* synthetic */ int access$100(EspressoForeignList x0) {
        return x0.modCount;
    }

    private class Itr
    implements Iterator<T> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = EspressoForeignList.access$100(EspressoForeignList.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != EspressoForeignList.this.size();
        }

        @Override
        public T next() {
            this.checkForComodification();
            try {
                int i = this.cursor;
                Object next = EspressoForeignList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new UnsupportedOperationException();
            }
            this.checkForComodification();
            try {
                EspressoForeignList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = EspressoForeignList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (EspressoForeignList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

