/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.polyglot;

import com.oracle.truffle.espresso.polyglot.Interop;
import com.oracle.truffle.espresso.polyglot.Polyglot;
import com.oracle.truffle.espresso.polyglot.UnsupportedMessageException;

public final class ForeignException
extends RuntimeException {
    private static final long serialVersionUID = -765815353576751011L;

    private ForeignException() {
        throw new RuntimeException("No instance of ForeignException can be created directly");
    }

    public native Object getForeignExceptionObject();

    @Override
    public String getMessage() {
        Object rawForeignObject = this.getForeignExceptionObject();
        assert (Interop.isException(rawForeignObject));
        if (Interop.hasExceptionMessage(rawForeignObject)) {
            try {
                Object message = Interop.getExceptionMessage(rawForeignObject);
                return Interop.asString(message);
            }
            catch (UnsupportedMessageException e) {
                throw new AssertionError("Unexpected exception", e);
            }
        }
        return null;
    }

    @Override
    public Throwable getCause() {
        Object rawForeignObject = this.getForeignExceptionObject();
        assert (Interop.isException(rawForeignObject));
        if (Interop.hasExceptionCause(rawForeignObject)) {
            Object cause;
            try {
                cause = Interop.getExceptionCause(rawForeignObject);
            }
            catch (UnsupportedMessageException e) {
                throw new AssertionError("Unexpected exception", e);
            }
            assert (Interop.isException(cause));
            if (Polyglot.isForeignObject(cause)) {
                return Polyglot.cast(ForeignException.class, cause);
            }
            return (Throwable)cause;
        }
        return null;
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            if (stackTrace[i] != null) continue;
            throw new NullPointerException("stackTrace[" + i + "]");
        }
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public Throwable initCause(Throwable cause) {
        throw new UnsupportedOperationException();
    }
}

