/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.polyglot;

import com.oracle.truffle.espresso.polyglot.ArityException;
import com.oracle.truffle.espresso.polyglot.ExceptionType;
import com.oracle.truffle.espresso.polyglot.InvalidArrayIndexException;
import com.oracle.truffle.espresso.polyglot.InvalidBufferOffsetException;
import com.oracle.truffle.espresso.polyglot.StopIterationException;
import com.oracle.truffle.espresso.polyglot.UnknownIdentifierException;
import com.oracle.truffle.espresso.polyglot.UnknownKeyException;
import com.oracle.truffle.espresso.polyglot.UnsupportedMessageException;
import com.oracle.truffle.espresso.polyglot.UnsupportedTypeException;
import java.nio.ByteOrder;

public final class Interop {
    private Interop() {
        throw new RuntimeException("No instance of Interop can be created");
    }

    public static native boolean isNull(Object var0);

    public static native boolean isBoolean(Object var0);

    public static native boolean asBoolean(Object var0) throws UnsupportedMessageException;

    public static native boolean isString(Object var0);

    public static native String asString(Object var0) throws UnsupportedMessageException;

    public static native boolean isNumber(Object var0);

    public static native boolean fitsInByte(Object var0);

    public static native boolean fitsInShort(Object var0);

    public static native boolean fitsInInt(Object var0);

    public static native boolean fitsInLong(Object var0);

    public static native boolean fitsInFloat(Object var0);

    public static native boolean fitsInDouble(Object var0);

    public static native byte asByte(Object var0) throws UnsupportedMessageException;

    public static native short asShort(Object var0) throws UnsupportedMessageException;

    public static native int asInt(Object var0) throws UnsupportedMessageException;

    public static native long asLong(Object var0) throws UnsupportedMessageException;

    public static native float asFloat(Object var0) throws UnsupportedMessageException;

    public static native double asDouble(Object var0) throws UnsupportedMessageException;

    public static native boolean isException(Object var0);

    public static native RuntimeException throwException(Object var0) throws UnsupportedMessageException;

    public static native ExceptionType getExceptionType(Object var0) throws UnsupportedMessageException;

    public static native boolean isExceptionIncompleteSource(Object var0) throws UnsupportedMessageException;

    public static native int getExceptionExitStatus(Object var0) throws UnsupportedMessageException;

    public static native boolean hasExceptionCause(Object var0);

    public static native Object getExceptionCause(Object var0) throws UnsupportedMessageException;

    public static native boolean hasExceptionMessage(Object var0);

    public static native Object getExceptionMessage(Object var0) throws UnsupportedMessageException;

    public static native boolean hasExceptionStackTrace(Object var0);

    public static native Object getExceptionStackTrace(Object var0) throws UnsupportedMessageException;

    public static native boolean hasArrayElements(Object var0);

    public static native Object readArrayElement(Object var0, long var1) throws UnsupportedMessageException, InvalidArrayIndexException;

    public static native long getArraySize(Object var0) throws UnsupportedMessageException;

    public static native boolean isArrayElementReadable(Object var0, long var1);

    public static native void writeArrayElement(Object var0, long var1, Object var3) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException;

    public static native void removeArrayElement(Object var0, long var1) throws UnsupportedMessageException, InvalidArrayIndexException;

    public static native boolean isArrayElementModifiable(Object var0, long var1);

    public static native boolean isArrayElementInsertable(Object var0, long var1);

    public static native boolean isArrayElementRemovable(Object var0, long var1);

    public static boolean isArrayElementWritable(Object receiver, long index) {
        return Interop.isArrayElementModifiable(receiver, index) || Interop.isArrayElementInsertable(receiver, index);
    }

    public static boolean isArrayElementExisting(Object receiver, long index) {
        return Interop.isArrayElementModifiable(receiver, index) || Interop.isArrayElementReadable(receiver, index) || Interop.isArrayElementRemovable(receiver, index);
    }

    public static native boolean hasMetaObject(Object var0);

    public static native Object getMetaObject(Object var0) throws UnsupportedMessageException;

    public static native Object toDisplayString(Object var0, boolean var1);

    public static Object toDisplayString(Object receiver) {
        return Interop.toDisplayString(receiver, true);
    }

    public static native boolean isMetaObject(Object var0);

    public static native Object getMetaQualifiedName(Object var0) throws UnsupportedMessageException;

    public static native Object getMetaSimpleName(Object var0) throws UnsupportedMessageException;

    public static native boolean isMetaInstance(Object var0, Object var1) throws UnsupportedMessageException;

    public static native boolean isIdentical(Object var0, Object var1);

    public static boolean hasIdentity(Object receiver) {
        return Interop.isIdentical(receiver, receiver);
    }

    public static native int identityHashCode(Object var0) throws UnsupportedMessageException;

    public static native boolean hasMembers(Object var0);

    public static native Object getMembers(Object var0) throws UnsupportedMessageException;

    public static native boolean isMemberReadable(Object var0, String var1);

    public static native Object readMember(Object var0, String var1) throws UnsupportedMessageException, UnknownIdentifierException;

    public static native boolean isMemberModifiable(Object var0, String var1);

    public static native boolean isMemberInsertable(Object var0, String var1);

    public static native void writeMember(Object var0, String var1, Object var2) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException;

    public static native boolean isMemberRemovable(Object var0, String var1);

    public static native void removeMember(Object var0, String var1) throws UnsupportedMessageException, UnknownIdentifierException;

    public static native boolean isMemberInvocable(Object var0, String var1);

    public static native Object invokeMember(Object var0, String var1, Object ... var2) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException;

    public static boolean isMemberWritable(Object receiver, String member) {
        return Interop.isMemberModifiable(receiver, member) || Interop.isMemberInsertable(receiver, member);
    }

    public static boolean isMemberExisting(Object receiver, String member) {
        return Interop.isMemberReadable(receiver, member) || Interop.isMemberModifiable(receiver, member) || Interop.isMemberRemovable(receiver, member) || Interop.isMemberInvocable(receiver, member);
    }

    public static native boolean hasMemberReadSideEffects(Object var0, String var1);

    public static native boolean hasMemberWriteSideEffects(Object var0, String var1);

    public static native boolean isPointer(Object var0);

    public static native long asPointer(Object var0) throws UnsupportedMessageException;

    public static native void toNative(Object var0);

    public static native boolean isExecutable(Object var0);

    public static native Object execute(Object var0, Object ... var1) throws UnsupportedTypeException, ArityException, UnsupportedMessageException;

    public static native boolean isInstantiable(Object var0);

    public static native Object instantiate(Object var0, Object ... var1) throws UnsupportedTypeException, ArityException, UnsupportedMessageException;

    public static native boolean hasExecutableName(Object var0);

    public static native Object getExecutableName(Object var0) throws UnsupportedMessageException;

    public static native boolean hasDeclaringMetaObject(Object var0);

    public static native Object getDeclaringMetaObject(Object var0) throws UnsupportedMessageException;

    public static native boolean hasBufferElements(Object var0);

    public static native boolean isBufferWritable(Object var0) throws UnsupportedMessageException;

    public static native long getBufferSize(Object var0) throws UnsupportedMessageException;

    public static native byte readBufferByte(Object var0, long var1) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native void writeBufferByte(Object var0, long var1, byte var3) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native short readBufferShort(Object var0, ByteOrder var1, long var2) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native void writeBufferShort(Object var0, ByteOrder var1, long var2, short var4) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native int readBufferInt(Object var0, ByteOrder var1, long var2) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native void writeBufferInt(Object var0, ByteOrder var1, long var2, int var4) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native long readBufferLong(Object var0, ByteOrder var1, long var2) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native void writeBufferLong(Object var0, ByteOrder var1, long var2, long var4) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native float readBufferFloat(Object var0, ByteOrder var1, long var2) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native void writeBufferFloat(Object var0, ByteOrder var1, long var2, float var4) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native double readBufferDouble(Object var0, ByteOrder var1, long var2) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native void writeBufferDouble(Object var0, ByteOrder var1, long var2, double var4) throws UnsupportedMessageException, InvalidBufferOffsetException;

    public static native boolean hasIterator(Object var0);

    public static native Object getIterator(Object var0) throws UnsupportedMessageException;

    public static native boolean isIterator(Object var0);

    public static native boolean hasIteratorNextElement(Object var0) throws UnsupportedMessageException;

    public static native Object getIteratorNextElement(Object var0) throws UnsupportedMessageException, StopIterationException;

    public static native boolean hasHashEntries(Object var0);

    public static native long getHashSize(Object var0) throws UnsupportedMessageException;

    public static native boolean isHashEntryReadable(Object var0, Object var1);

    public static native Object readHashValue(Object var0, Object var1) throws UnsupportedMessageException, UnknownKeyException;

    public static native Object readHashValueOrDefault(Object var0, Object var1, Object var2) throws UnsupportedMessageException;

    public static native boolean isHashEntryModifiable(Object var0, Object var1);

    public static native boolean isHashEntryInsertable(Object var0, Object var1);

    public static native boolean isHashEntryWritable(Object var0, Object var1);

    public static native void writeHashEntry(Object var0, Object var1, Object var2) throws UnsupportedMessageException, UnknownKeyException, UnsupportedTypeException;

    public static native boolean isHashEntryRemovable(Object var0, Object var1);

    public static native void removeHashEntry(Object var0, Object var1) throws UnsupportedMessageException, UnknownKeyException;

    public static native boolean isHashEntryExisting(Object var0, Object var1);

    public static native Object getHashEntriesIterator(Object var0) throws UnsupportedMessageException;

    public static native Object getHashKeysIterator(Object var0) throws UnsupportedMessageException;

    public static native Object getHashValuesIterator(Object var0) throws UnsupportedMessageException;
}

