/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.polyglot;

import com.oracle.truffle.espresso.polyglot.Interop;
import com.oracle.truffle.espresso.polyglot.InteropException;
import com.oracle.truffle.espresso.polyglot.UnsupportedMessageException;

public final class UnknownKeyException
extends InteropException {
    private static final long serialVersionUID = 1857745390734085182L;
    private final Object unknownKey;

    private UnknownKeyException(Object unknownKey) {
        super((String)null);
        this.unknownKey = unknownKey;
    }

    private UnknownKeyException(Object unknownKey, Throwable cause) {
        super(null, cause);
        this.unknownKey = unknownKey;
    }

    @Override
    public String getMessage() {
        try {
            return "Unknown identifier: " + Interop.asString(Interop.toDisplayString(this.unknownKey, false));
        }
        catch (UnsupportedMessageException e) {
            throw new AssertionError("shouldNotReachHere", e);
        }
    }

    public Object getUnknownKey() {
        return this.unknownKey;
    }

    public static UnknownKeyException create(Object unknownKey) {
        return new UnknownKeyException(unknownKey);
    }

    public static UnknownKeyException create(Object unknownKey, Throwable cause) {
        return new UnknownKeyException(unknownKey, cause);
    }
}

