/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.hotswap;

import com.oracle.truffle.espresso.hotswap.HotSwapAction;
import com.oracle.truffle.espresso.hotswap.HotSwapPlugin;
import com.oracle.truffle.espresso.hotswap.ServiceWatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class HotSwapHandler {
    private static HotSwapHandler theHandler;
    private final Set<HotSwapPlugin> plugins = new HashSet<HotSwapPlugin>();
    private final Map<Class<?>, Set<HotSwapAction>> hotSwapActions = new HashMap();
    private final List<HotSwapAction> postHotSwapActions = new ArrayList<HotSwapAction>();
    private final Map<Class<?>, Boolean> staticInitializerHotSwap = new HashMap();
    private final Map<Class<?>, List<HotSwapAction>> staticReInitCallBacks = new HashMap();
    private final ServiceWatcher serviceWatcher = new ServiceWatcher();

    private HotSwapHandler() {
    }

    static HotSwapHandler create() {
        theHandler = new HotSwapHandler();
        return HotSwapHandler.registerHandler(theHandler) ? theHandler : null;
    }

    private static boolean registerHandler(Object handler) {
        return false;
    }

    synchronized void addPlugin(HotSwapPlugin plugin) {
        this.plugins.add(plugin);
    }

    public synchronized void registerHotSwapAction(Class<?> klass, HotSwapAction action) {
        this.hotSwapActions.putIfAbsent(klass, new HashSet());
        this.hotSwapActions.get(klass).add(action);
    }

    public synchronized void registerPostHotSwapAction(HotSwapAction action) {
        this.postHotSwapActions.add(action);
    }

    public synchronized void registerStaticClassInitHotSwap(Class<?> klass, boolean onChange, HotSwapAction callback) {
        if (!this.staticInitializerHotSwap.containsKey(klass)) {
            this.staticInitializerHotSwap.put(klass, onChange);
        } else if (!onChange) {
            this.staticInitializerHotSwap.put(klass, false);
        }
        if (callback != null) {
            List<HotSwapAction> reInitCallbacks = this.staticReInitCallBacks.get(klass);
            if (reInitCallbacks == null) {
                reInitCallbacks = new ArrayList<HotSwapAction>(1);
                this.staticReInitCallBacks.put(klass, reInitCallbacks);
            }
            reInitCallbacks.add(callback);
        }
    }

    public synchronized void registerMetaInfServicesListener(Class<?> service, ClassLoader loader, HotSwapAction callback) throws IOException {
        this.serviceWatcher.addServiceWatcher(service, loader, callback);
    }

    public synchronized boolean registerResourceListener(ClassLoader loader, String resource, HotSwapAction callback) throws IOException {
        return this.serviceWatcher.addResourceWatcher(loader, resource, callback);
    }

    public synchronized void postHotSwap(Class<?>[] changedClasses) {
        new Thread(() -> {
            for (HotSwapPlugin plugin : this.plugins) {
                try {
                    plugin.postHotSwap(changedClasses);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            for (Class klass : changedClasses) {
                Set actions = this.hotSwapActions.getOrDefault(klass, Collections.emptySet());
                for (HotSwapAction action : actions) {
                    try {
                        action.fire();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            for (HotSwapAction postHotSwapAction : this.postHotSwapActions) {
                try {
                    postHotSwapAction.fire();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }).start();
    }

    public synchronized boolean shouldRerunClassInitializer(Class<?> klass, boolean changed) {
        if (this.staticInitializerHotSwap.containsKey(klass)) {
            boolean rerun;
            boolean onlyOnChange = this.staticInitializerHotSwap.get(klass);
            boolean bl = rerun = !onlyOnChange || changed;
            if (rerun) {
                this.staticReInitCallBacks.getOrDefault(klass, Collections.emptyList()).forEach(HotSwapAction::fire);
            }
            return rerun;
        }
        for (Map.Entry<Class<?>, Boolean> entry : this.staticInitializerHotSwap.entrySet()) {
            boolean rerun;
            Class<?> key = entry.getKey();
            if (!key.isAssignableFrom(klass)) continue;
            boolean bl = rerun = entry.getValue() == false || changed;
            if (rerun) {
                this.staticReInitCallBacks.getOrDefault(key, Collections.emptyList()).forEach(HotSwapAction::fire);
            }
            return rerun;
        }
        return false;
    }
}

