/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.hotswap;

import com.oracle.truffle.espresso.hotswap.HotSwapAction;
import com.oracle.truffle.espresso.hotswap.HotSwapHandler;
import com.oracle.truffle.espresso.hotswap.HotSwapPlugin;
import java.io.IOException;

public final class EspressoHotSwap {
    private static final HotSwapHandler handler = HotSwapHandler.create();

    private EspressoHotSwap() {
        throw new RuntimeException("No instance of EspressoHotSwap can be created");
    }

    public static boolean registerPlugin(HotSwapPlugin plugin) {
        if (handler != null) {
            handler.addPlugin(plugin);
        }
        return handler != null;
    }

    public static boolean registerPostHotSwapAction(HotSwapAction action) {
        if (handler != null) {
            handler.registerPostHotSwapAction(action);
        }
        return handler != null;
    }

    public static boolean registerHotSwapAction(Class<?> klass, HotSwapAction action) {
        if (handler != null) {
            handler.registerHotSwapAction(klass, action);
        }
        return handler != null;
    }

    public static boolean registerClassInitHotSwap(Class<?> klass, boolean onChange, HotSwapAction action) {
        if (handler != null) {
            handler.registerStaticClassInitHotSwap(klass, onChange, action);
        }
        return handler != null;
    }

    public static boolean registerResourceListener(ClassLoader loader, String resource, HotSwapAction action) throws IOException {
        if (handler != null) {
            return handler.registerResourceListener(loader, resource, action);
        }
        return false;
    }

    public static boolean registerMetaInfServicesListener(Class<?> serviceType, ClassLoader loader, HotSwapAction action) throws IOException {
        if (handler != null) {
            handler.registerMetaInfServicesListener(serviceType, loader, action);
        }
        return handler != null;
    }
}

