/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.hotswap;

import com.oracle.truffle.espresso.hotswap.HotSwapAction;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;

final class ServiceWatcher {
    private static final String PREFIX = "META-INF/services/";
    private static final WatchEvent.Kind<?>[] ALL_WATCH_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW};
    private static final WatchEvent.Kind<?>[] CREATE_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.OVERFLOW};
    private static final WatchEvent.Kind<?>[] DELETE_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW};
    private static final WatchEvent.Kind<?>[] CREATE_DELETE_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW};
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final Map<String, Set<String>> services = new HashMap<String, Set<String>>(4);
    private WatcherThread serviceWatcherThread;
    private URLWatcher urlWatcher;

    ServiceWatcher() {
    }

    public boolean addResourceWatcher(ClassLoader loader, String resource, HotSwapAction callback) throws IOException {
        this.ensureInitialized();
        URL url = loader == null ? ClassLoader.getSystemResource(resource) : loader.getResource(resource);
        if (url == null) {
            throw new IOException("Resource " + resource + " not found from class loader: " + loader.getClass().getName());
        }
        if ("file".equals(url.getProtocol())) {
            try {
                Path path = Paths.get(url.toURI());
                this.serviceWatcherThread.addWatch(path, () -> callback.fire());
                return true;
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return false;
    }

    public synchronized void addServiceWatcher(Class<?> service, ClassLoader loader, HotSwapAction callback) throws IOException {
        this.ensureInitialized();
        Set<String> serviceImpl = Collections.synchronizedSet(new HashSet());
        ServiceLoader<?> serviceLoader = ServiceLoader.load(service, loader);
        Iterator<?> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                Object o = iterator.next();
                serviceImpl.add(o.getClass().getName());
            }
            catch (ServiceConfigurationError o) {}
        }
        String fullName = PREFIX + service.getName();
        this.services.put(fullName, serviceImpl);
        ArrayList<URL> initialURLs = new ArrayList<URL>();
        Enumeration<URL> urls = loader == null ? ClassLoader.getSystemResources(fullName) : loader.getResources(fullName);
        while (urls.hasMoreElements()) {
            URL url2 = urls.nextElement();
            if (!"file".equals(url2.getProtocol())) continue;
            try {
                Path path = Paths.get(url2.toURI());
                initialURLs.add(url2);
                this.serviceWatcherThread.addWatch(path, () -> this.onServiceChange(callback, serviceLoader, fullName));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        this.urlWatcher.addWatch(new URLServiceState(initialURLs, loader, fullName, url -> {
            try {
                callback.fire();
            }
            catch (Throwable t) {
                System.err.println("[HotSwap API]: Unexpected exception while running service change action");
                t.printStackTrace();
            }
            try {
                Path path = Paths.get(url.toURI());
                this.serviceWatcherThread.addWatch(path, () -> this.onServiceChange(callback, serviceLoader, fullName));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }, () -> {
            try {
                callback.fire();
            }
            catch (Throwable t) {
                System.err.println("[HotSwap API]: Unexpected exception while running service change action");
                t.printStackTrace();
            }
        }));
    }

    private void ensureInitialized() throws IOException {
        if (this.serviceWatcherThread == null) {
            this.serviceWatcherThread = new WatcherThread();
            this.serviceWatcherThread.start();
            this.urlWatcher = new URLWatcher();
            this.urlWatcher.startWatching();
        }
    }

    private synchronized void onServiceChange(HotSwapAction callback, ServiceLoader<?> serviceLoader, String fullName) {
        serviceLoader.reload();
        Set currentServiceImpl = this.services.getOrDefault(fullName, Collections.emptySet());
        Set<String> changedServiceImpl = Collections.synchronizedSet(new HashSet(currentServiceImpl.size() + 1));
        Iterator<?> it = serviceLoader.iterator();
        boolean callbackFired = false;
        while (it.hasNext()) {
            try {
                Object o = it.next();
                changedServiceImpl.add(o.getClass().getName());
                if (currentServiceImpl.contains(o.getClass().getName())) continue;
                callback.fire();
                callbackFired = true;
                break;
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
            }
        }
        if (!callbackFired && changedServiceImpl.size() != currentServiceImpl.size()) {
            callback.fire();
        }
        this.services.put(fullName, changedServiceImpl);
    }

    private static byte[] calculateChecksum(Path resourcePath) {
        try {
            byte[] buffer = new byte[4096];
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (InputStream is = Files.newInputStream(resourcePath, new OpenOption[0]);
                 DigestInputStream dis = new DigestInputStream(is, md);){
                while (dis.read(buffer) != -1) {
                    dis.read();
                }
            }
            return md.digest();
        }
        catch (Exception e) {
            System.err.println("[HotSwap API]: unable to calculate checksum for watched resource " + resourcePath);
            return EMPTY_BYTE_ARRAY;
        }
    }

    private final class URLServiceState {
        private List<URL> knownURLs;
        private final ClassLoader classLoader;
        private final String fullName;
        private final Function<URL, Void> onAddedURL;
        private final Runnable onRemovedURL;

        private URLServiceState(ArrayList<URL> initialURLs, ClassLoader classLoader, String fullName, Function<URL, Void> onAddedURL, Runnable onRemovedURL) {
            this.knownURLs = Collections.synchronizedList(initialURLs);
            this.classLoader = classLoader;
            this.fullName = fullName;
            this.onAddedURL = onAddedURL;
            this.onRemovedURL = onRemovedURL;
        }

        private void detectChanges() {
            try {
                boolean changed = false;
                ArrayList<URL> currentURLs = new ArrayList<URL>(this.knownURLs.size());
                Enumeration<URL> urls = this.classLoader == null ? ClassLoader.getSystemResources(this.fullName) : this.classLoader.getResources(this.fullName);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (!"file".equals(url.getProtocol())) continue;
                    currentURLs.add(url);
                    if (this.knownURLs.contains(url)) continue;
                    changed = true;
                    this.onAddedURL.apply(url);
                }
                if (currentURLs.size() != this.knownURLs.size()) {
                    changed = true;
                    this.onRemovedURL.run();
                }
                if (changed) {
                    this.knownURLs = currentURLs;
                }
            }
            catch (IOException e) {
                return;
            }
        }
    }

    private final class URLWatcher {
        private final List<URLServiceState> cache = Collections.synchronizedList(new ArrayList());

        private URLWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addWatch(URLServiceState state) {
            List<URLServiceState> list = this.cache;
            synchronized (list) {
                this.cache.add(state);
            }
        }

        public void startWatching() {
            TimerTask task = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = URLWatcher.this.cache;
                    synchronized (list) {
                        for (URLServiceState urlServiceState : URLWatcher.this.cache) {
                            urlServiceState.detectChanges();
                        }
                    }
                }
            };
            ScheduledExecutorService es = Executors.newSingleThreadScheduledExecutor();
            es.scheduleWithFixedDelay(task, 500L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    private static final class State {
        private byte[] checksum;
        private Runnable action;

        State(byte[] checksum, Runnable action) {
            this.checksum = checksum;
            this.action = action;
        }

        public Runnable getAction() {
            return this.action;
        }

        public boolean hasChanged(Path path) {
            byte[] currentChecksum = ServiceWatcher.calculateChecksum(path);
            if (!MessageDigest.isEqual(currentChecksum, this.checksum)) {
                this.checksum = currentChecksum;
                return true;
            }
            return this.checksum.length == 0 || currentChecksum.length == 0;
        }
    }

    private final class WatcherThread
    extends Thread {
        private final WatchService watchService;
        private final Map<Path, State> watchActions;
        private final Map<Path, Set<Path>> watchedForDeletion;
        private final Map<Path, Set<Path>> watchedForCreation;
        private final Map<Path, WatchKey> registeredWatches;
        private final Map<Path, Map<Path, Integer>> activeFileWatches;

        private WatcherThread() throws IOException {
            super("hotswap-watcher-1");
            this.watchActions = Collections.synchronizedMap(new HashMap());
            this.watchedForDeletion = new HashMap<Path, Set<Path>>();
            this.watchedForCreation = new HashMap<Path, Set<Path>>();
            this.registeredWatches = new HashMap<Path, WatchKey>();
            this.activeFileWatches = new HashMap<Path, Map<Path, Integer>>();
            this.setDaemon(true);
            this.watchService = FileSystems.getDefault().newWatchService();
        }

        public void addWatch(Path resourcePath, Runnable callback) throws IOException {
            this.watchActions.put(resourcePath, new State(ServiceWatcher.calculateChecksum(resourcePath), callback));
            Path dir = resourcePath.getParent();
            if (dir == null) {
                throw new IOException("parent directory doesn't exist for: " + resourcePath);
            }
            this.registerFileSystemWatch(dir, resourcePath, ALL_WATCH_KINDS);
        }

        private void addWatchedDeletedFolder(Path path, Path leaf) {
            Set<Path> set = this.watchedForDeletion.get(path);
            if (set == null) {
                set = new HashSet<Path>();
                this.watchedForDeletion.put(path, set);
            }
            set.add(leaf);
        }

        private void addWatchedCreatedFolder(Path path, Path leaf) {
            Set<Path> set = this.watchedForCreation.get(path);
            if (set == null) {
                set = new HashSet<Path>();
                this.watchedForCreation.put(path, set);
            }
            set.add(leaf);
        }

        @Override
        public void run() {
            try {
                WatchKey key;
                while ((key = this.watchService.take()) != null) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                            for (Path path : this.watchActions.keySet()) {
                                this.scanDir(path.getParent());
                            }
                            continue;
                        }
                        String fileName = event.context().toString();
                        Path watchPath = null;
                        Watchable watchable = key.watchable();
                        if (watchable instanceof Path) {
                            watchPath = (Path)watchable;
                        }
                        if (watchPath == null) continue;
                        Path resourcePath = watchPath.resolve(fileName);
                        if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                            if (this.watchActions.containsKey(resourcePath)) {
                                this.handleDeletedResource(watchPath, resourcePath);
                                continue;
                            }
                            if (!this.watchedForDeletion.containsKey(resourcePath)) continue;
                            this.handleDeletedFolderEvent(resourcePath);
                            continue;
                        }
                        if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                            if (this.watchActions.containsKey(resourcePath)) {
                                this.handleCreatedResource(watchPath, resourcePath);
                                continue;
                            }
                            if (!this.watchedForCreation.containsKey(resourcePath)) continue;
                            this.handleCreatedFolderEvent(resourcePath);
                            continue;
                        }
                        if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !this.watchActions.containsKey(resourcePath)) continue;
                        this.detectChange(resourcePath);
                    }
                    key.reset();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Espresso HotSwap service watcher thread was interrupted!");
            }
        }

        private void handleDeletedResource(Path watchPath, Path resourcePath) {
            this.addWatchedDeletedFolder(watchPath, resourcePath);
            this.removeFilesystemWatchReason(watchPath, resourcePath);
            Path parent = watchPath.getParent();
            if (parent == null) {
                return;
            }
            try {
                this.registerFileSystemWatch(parent, watchPath, DELETE_KINDS);
            }
            catch (IOException e) {
                this.handleDeletedFolderEvent(watchPath);
                return;
            }
            if (!Files.exists(watchPath, new LinkOption[0])) {
                this.handleDeletedFolderEvent(watchPath);
            } else {
                try {
                    this.registerFileSystemWatch(watchPath, resourcePath, ALL_WATCH_KINDS);
                }
                catch (IOException e) {
                    this.handleDeletedFolderEvent(watchPath);
                }
                this.scanDir(watchPath);
            }
        }

        private void handleCreatedResource(Path watchPath, Path resourcePath) {
            this.removeFilesystemWatchReason(watchPath.getParent(), watchPath);
            Set set = this.watchedForDeletion.getOrDefault(watchPath, Collections.emptySet());
            set.remove(resourcePath);
            if (set.isEmpty()) {
                this.watchedForDeletion.remove(watchPath);
            }
            this.detectChange(resourcePath);
        }

        private synchronized void registerFileSystemWatch(Path path, Path reason, WatchEvent.Kind<?>[] kinds) throws IOException {
            WatchKey watchKey = path.register(this.watchService, kinds);
            this.registeredWatches.put(path, watchKey);
            Map<Path, Integer> reasons = this.activeFileWatches.get(path);
            if (reasons == null) {
                reasons = new HashMap<Path, Integer>(1);
                this.activeFileWatches.put(path, reasons);
            }
            reasons.put(reason, reasons.getOrDefault(reason, 0) + 1);
        }

        private synchronized void removeFilesystemWatchReason(Path path, Path reason) {
            Map<Path, Integer> reasons = this.activeFileWatches.getOrDefault(path, Collections.emptyMap());
            int count = reasons.getOrDefault(reason, 0);
            if (count <= 1) {
                reasons.remove(reason);
            } else {
                reasons.put(reason, (Integer)reasons.get(reason) - 1);
            }
            if (reasons.isEmpty()) {
                this.activeFileWatches.remove(path);
                WatchKey watchKey = this.registeredWatches.remove(path);
                if (watchKey != null) {
                    watchKey.cancel();
                }
            }
        }

        private void handleCreatedFolderEvent(Path path) {
            Path parent = path.getParent();
            if (parent == null) {
                return;
            }
            Set<Path> leaves = this.watchedForCreation.remove(path);
            Set deleteLeaves = this.watchedForDeletion.getOrDefault(parent, Collections.emptySet());
            deleteLeaves.removeAll(leaves);
            if (deleteLeaves.isEmpty()) {
                this.watchedForDeletion.remove(parent);
            }
            HashSet<Path> directResources = new HashSet<Path>();
            HashSet<Path> childrenToWatch = new HashSet<Path>();
            for (Path leaf : leaves) {
                this.addWatchedDeletedFolder(path, leaf);
                this.removeFilesystemWatchReason(parent.getParent(), parent);
                this.removeFilesystemWatchReason(parent, path);
                if (path.equals(leaf.getParent())) {
                    directResources.add(leaf);
                    continue;
                }
                Path current = leaf;
                while (current != null && !current.equals(path)) {
                    Path currentParent = current.getParent();
                    if (path.equals(currentParent)) {
                        this.addWatchedCreatedFolder(current, leaf);
                        childrenToWatch.add(current);
                    }
                    current = currentParent;
                }
            }
            try {
                for (Path directResource : directResources) {
                    this.registerFileSystemWatch(path, directResource, ALL_WATCH_KINDS);
                }
                for (Path toWatch : childrenToWatch) {
                    this.registerFileSystemWatch(path, toWatch, CREATE_KINDS);
                }
                this.scanDir(path);
            }
            catch (IOException e) {
                if (!Files.exists(path, new LinkOption[0])) {
                    this.handleDeletedFolderEvent(path);
                }
                System.err.println("[HotSwap API]: Unexpected exception while handling creation of path: " + path);
                e.printStackTrace();
            }
        }

        private void handleDeletedFolderEvent(Path path) {
            Path parent = path.getParent();
            if (parent == null) {
                return;
            }
            Set<Path> leaves = this.watchedForDeletion.remove(path);
            if (leaves == null) {
                return;
            }
            for (Path leaf : leaves) {
                this.addWatchedDeletedFolder(parent, leaf);
                this.transferCreationWatch(path, leaf);
            }
            this.removeFilesystemWatchReason(parent, path);
            try {
                Path grandParent = parent.getParent();
                if (grandParent != null) {
                    this.registerDeleteFileSystemWatch(grandParent, parent);
                }
                if (Files.exists(parent, new LinkOption[0]) && Files.isReadable(parent)) {
                    this.registerCreateFileSystemWatch(parent, path);
                    this.scanDir(parent);
                } else {
                    this.handleDeletedFolderEvent(parent);
                }
            }
            catch (IOException e) {
                this.handleDeletedFolderEvent(parent);
            }
        }

        private void transferCreationWatch(Path path, Path leaf) {
            Path current = leaf;
            while (current != path) {
                Path parent = current.getParent();
                if (parent != null && parent.equals(path)) {
                    this.watchedForCreation.remove(current);
                    this.addWatchedCreatedFolder(path, leaf);
                    this.removeFilesystemWatchReason(path, current);
                    break;
                }
                current = parent;
            }
        }

        private void registerDeleteFileSystemWatch(Path path, Path reason) throws IOException {
            if (!this.watchedForCreation.getOrDefault(path, Collections.emptySet()).isEmpty()) {
                this.registerFileSystemWatch(path, reason, CREATE_DELETE_KINDS);
            } else {
                this.registerFileSystemWatch(path, reason, DELETE_KINDS);
            }
        }

        private void registerCreateFileSystemWatch(Path path, Path reason) throws IOException {
            if (!this.watchedForDeletion.getOrDefault(path, Collections.emptySet()).isEmpty()) {
                this.registerFileSystemWatch(path, reason, CREATE_DELETE_KINDS);
            } else {
                this.registerFileSystemWatch(path, reason, CREATE_KINDS);
            }
        }

        private void detectChange(Path path) {
            State state = this.watchActions.get(path);
            if (state.hasChanged(path)) {
                try {
                    state.getAction().run();
                }
                catch (Throwable t) {
                    System.err.println("[HotSwap API]: Unexpected exception while running resource change action for: " + path);
                    t.printStackTrace();
                }
            }
        }

        private void scanDir(Path dir) {
            try (Stream<Path> list = Files.list(dir);){
                list.forEach(path -> {
                    if (this.watchActions.containsKey(path)) {
                        this.handleCreatedResource(dir, (Path)path);
                    } else if (this.watchedForCreation.containsKey(path)) {
                        this.handleCreatedFolderEvent((Path)path);
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

