/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.structs;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.ffi.NativeAccess;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.jni.JNIHandles;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.structs.GenerateStructs;
import java.nio.ByteBuffer;

@GenerateStructs(value={@GenerateStructs.KnownStruct(structName="JavaVMAttachArgs", memberNames={"version", "name", "group"}, types={NativeType.INT, NativeType.POINTER, NativeType.OBJECT}), @GenerateStructs.KnownStruct(structName="member_info", memberNames={"id", "offset", "next"}, types={NativeType.POINTER, NativeType.LONG, NativeType.POINTER}), @GenerateStructs.KnownStruct(structName="_jvmtiThreadInfo", memberNames={"name", "priority", "is_daemon", "thread_group", "context_class_loader"}, types={NativeType.POINTER, NativeType.INT, NativeType.BOOLEAN, NativeType.OBJECT, NativeType.OBJECT}), @GenerateStructs.KnownStruct(structName="_jvmtiMonitorStackDepthInfo", memberNames={"monitor", "stack_depth"}, types={NativeType.OBJECT, NativeType.INT}), @GenerateStructs.KnownStruct(structName="_jvmtiThreadGroupInfo", memberNames={"parent", "name", "max_priority", "is_daemon"}, types={NativeType.OBJECT, NativeType.POINTER, NativeType.INT, NativeType.BOOLEAN}), @GenerateStructs.KnownStruct(structName="_jvmtiFrameInfo", memberNames={"method", "location"}, types={NativeType.LONG, NativeType.LONG}), @GenerateStructs.KnownStruct(structName="_jvmtiStackInfo", memberNames={"thread", "state", "frame_buffer", "frame_count"}, types={NativeType.OBJECT, NativeType.INT, NativeType.POINTER, NativeType.INT}), @GenerateStructs.KnownStruct(structName="_jvmtiHeapReferenceInfoField", memberNames={"index"}, types={NativeType.INT}), @GenerateStructs.KnownStruct(structName="_jvmtiHeapReferenceInfoArray", memberNames={"index"}, types={NativeType.INT}), @GenerateStructs.KnownStruct(structName="_jvmtiHeapReferenceInfoConstantPool", memberNames={"index"}, types={NativeType.INT}), @GenerateStructs.KnownStruct(structName="_jvmtiHeapReferenceInfoStackLocal", memberNames={"thread_tag", "thread_id", "depth", "method", "location", "slot"}, types={NativeType.LONG, NativeType.LONG, NativeType.INT, NativeType.LONG, NativeType.LONG, NativeType.INT}), @GenerateStructs.KnownStruct(structName="_jvmtiHeapReferenceInfoJniLocal", memberNames={"thread_tag", "thread_id", "depth", "method"}, types={NativeType.LONG, NativeType.LONG, NativeType.INT, NativeType.LONG}), @GenerateStructs.KnownStruct(structName="_jvmtiHeapReferenceInfoReserved", memberNames={"reserved1", "reserved2", "reserved3", "reserved4", "reserved5", "reserved6", "reserved7", "reserved8"}, types={NativeType.LONG, NativeType.LONG, NativeType.LONG, NativeType.LONG, NativeType.LONG, NativeType.LONG, NativeType.LONG, NativeType.LONG}), @GenerateStructs.KnownStruct(structName="_jvmtiHeapCallbacks", memberNames={"heap_iteration_callback", "heap_reference_callback", "primitive_field_callback", "array_primitive_value_callback", "string_primitive_value_callback", "reserved5", "reserved6", "reserved7", "reserved8", "reserved9", "reserved10", "reserved11", "reserved12", "reserved13", "reserved14", "reserved15"}, types={NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER}), @GenerateStructs.KnownStruct(structName="_jvmtiClassDefinition", memberNames={"klass", "class_byte_count", "class_bytes"}, types={NativeType.OBJECT, NativeType.INT, NativeType.POINTER}), @GenerateStructs.KnownStruct(structName="_jvmtiMonitorUsage", memberNames={"owner", "entry_count", "waiter_count", "waiters", "notify_waiter_count", "notify_waiters"}, types={NativeType.OBJECT, NativeType.INT, NativeType.INT, NativeType.POINTER, NativeType.INT, NativeType.POINTER}), @GenerateStructs.KnownStruct(structName="_jvmtiLineNumberEntry", memberNames={"start_location", "line_number"}, types={NativeType.LONG, NativeType.INT}), @GenerateStructs.KnownStruct(structName="_jvmtiLocalVariableEntry", memberNames={"start_location", "length", "name", "signature", "generic_signature", "slot"}, types={NativeType.LONG, NativeType.INT, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.INT}), @GenerateStructs.KnownStruct(structName="_jvmtiParamInfo", memberNames={"name", "kind", "base_type", "null_ok"}, types={NativeType.POINTER, NativeType.INT, NativeType.INT, NativeType.BOOLEAN}), @GenerateStructs.KnownStruct(structName="_jvmtiExtensionFunctionInfo", memberNames={"func", "id", "short_description", "param_count", "params", "error_count", "errors"}, types={NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.INT, NativeType.POINTER, NativeType.INT, NativeType.POINTER}), @GenerateStructs.KnownStruct(structName="_jvmtiExtensionEventInfo", memberNames={"extension_event_index", "id", "short_description", "param_count", "params"}, types={NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.INT, NativeType.POINTER}), @GenerateStructs.KnownStruct(structName="_jvmtiTimerInfo", memberNames={"max_value", "may_skip_forward", "may_skip_backward", "kind", "reserved1", "reserved2"}, types={NativeType.LONG, NativeType.BOOLEAN, NativeType.BOOLEAN, NativeType.INT, NativeType.LONG, NativeType.LONG}), @GenerateStructs.KnownStruct(structName="_jvmtiAddrLocationMap", memberNames={"start_address", "location"}, types={NativeType.POINTER, NativeType.LONG}), @GenerateStructs.KnownStruct(structName="_jvmtiEventCallbacks", memberNames={"VMInit", "VMDeath", "ThreadStart", "ThreadEnd", "ClassFileLoadHook", "ClassLoad", "ClassPrepare", "VMStart", "Exception", "ExceptionCatch", "SingleStep", "FramePop", "Breakpoint", "FieldAccess", "FieldModification", "MethodEntry", "MethodExit", "NativeMethodBind", "CompiledMethodLoad", "CompiledMethodUnload", "DynamicCodeGenerated", "DataDumpRequest", "reserved72", "MonitorWait", "MonitorWaited", "MonitorContendedEnter", "MonitorContendedEntered", "reserved77", "reserved78", "reserved79", "ResourceExhausted", "GarbageCollectionStart", "GarbageCollectionFinish", "ObjectFree", "VMObjectAlloc", "reserved85", "SampledObjectAlloc"}, types={NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER})})
public abstract class StructWrapper {
    private final JNIHandles handles;
    private final TruffleObject pointer;
    private final ByteBuffer buffer;

    public TruffleObject pointer() {
        return this.pointer;
    }

    public void free(NativeAccess nativeAccess) {
        nativeAccess.freeMemory(this.pointer);
    }

    protected StructWrapper(JniEnv jni, TruffleObject pointer, long capacity) {
        this.handles = jni.getHandles();
        this.pointer = pointer;
        this.buffer = NativeUtils.directByteBuffer(pointer, capacity);
    }

    protected boolean getBoolean(int offset) {
        return this.buffer.get(offset) != 0;
    }

    protected void putBoolean(int offset, boolean value) {
        this.buffer.put(offset, (byte)(value ? 1 : 0));
    }

    protected byte getByte(int offset) {
        return this.buffer.get(offset);
    }

    protected void putByte(int offset, byte value) {
        this.buffer.put(offset, value);
    }

    protected char getChar(int offset) {
        return this.buffer.getChar(offset);
    }

    protected void putChar(int offset, char value) {
        this.buffer.putChar(offset, value);
    }

    protected short getShort(int offset) {
        return this.buffer.getShort(offset);
    }

    protected void putShort(int offset, short value) {
        this.buffer.putShort(offset, value);
    }

    protected int getInt(int offset) {
        return this.buffer.getInt(offset);
    }

    protected void putInt(int offset, int value) {
        this.buffer.putInt(offset, value);
    }

    protected float getFloat(int offset) {
        return this.buffer.getFloat(offset);
    }

    protected void putFloat(int offset, float value) {
        this.buffer.putFloat(offset, value);
    }

    protected long getLong(int offset) {
        return this.buffer.getLong(offset);
    }

    protected void putLong(int offset, long value) {
        this.buffer.putLong(offset, value);
    }

    protected double getDouble(int offset) {
        return this.buffer.getDouble(offset);
    }

    protected void putDouble(int offset, double value) {
        this.buffer.putDouble(offset, value);
    }

    protected TruffleObject getPointer(int offset) {
        return RawPointer.create(this.buffer.getLong(offset));
    }

    protected void putPointer(int offset, TruffleObject value) {
        this.buffer.putLong(offset, NativeUtils.interopAsPointer(value));
    }

    protected StaticObject getObject(int offset) {
        return this.handles.get(Math.toIntExact(this.buffer.getLong(offset)));
    }

    protected void putObject(int offset, StaticObject value) {
        this.buffer.putLong(offset, this.handles.createLocal(value));
    }
}

