/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.structs;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.jni.RawBuffer;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.vm.structs.MemberOffsetGetter;

public final class NativeMemberOffsetGetter
implements MemberOffsetGetter {
    private final InteropLibrary library;
    private final TruffleObject memberInfoPtr;
    private final TruffleObject lookupMemberOffset;

    public NativeMemberOffsetGetter(InteropLibrary library, TruffleObject memberInfoPtr, TruffleObject lookupMemberOffset) {
        this.library = library;
        this.memberInfoPtr = memberInfoPtr;
        this.lookupMemberOffset = lookupMemberOffset;
    }

    @Override
    public long getInfo(String str) {
        long result = this.lookupInfo(str);
        if (result == -1L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Struct offset lookup for " + str + " failed.");
        }
        return result;
    }

    private long lookupInfo(String str) {
        RawBuffer memberBuffer = RawBuffer.getNativeString(str);
        try {
            long l = (Long)this.library.execute((Object)this.lookupMemberOffset, new Object[]{this.memberInfoPtr, memberBuffer.pointer()});
            if (memberBuffer != null) {
                memberBuffer.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (memberBuffer != null) {
                    try {
                        memberBuffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw EspressoError.shouldNotReachHere(e);
            }
        }
    }
}

