/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.structs;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.structs.MemberOffsetGetter;
import com.oracle.truffle.espresso.vm.structs.StructStorage;
import com.oracle.truffle.espresso.vm.structs.StructWrapper;

public final class JvmtiMonitorUsage
extends StructStorage<JvmtiMonitorUsageWrapper> {
    final int owner;
    final int entry_count;
    final int waiter_count;
    final int waiters;
    final int notify_waiter_count;
    final int notify_waiters;

    JvmtiMonitorUsage(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiMonitorUsage"));
        this.owner = (int)offsetGetter.getOffset("_jvmtiMonitorUsage", "owner");
        this.entry_count = (int)offsetGetter.getOffset("_jvmtiMonitorUsage", "entry_count");
        this.waiter_count = (int)offsetGetter.getOffset("_jvmtiMonitorUsage", "waiter_count");
        this.waiters = (int)offsetGetter.getOffset("_jvmtiMonitorUsage", "waiters");
        this.notify_waiter_count = (int)offsetGetter.getOffset("_jvmtiMonitorUsage", "notify_waiter_count");
        this.notify_waiters = (int)offsetGetter.getOffset("_jvmtiMonitorUsage", "notify_waiters");
    }

    @Override
    public JvmtiMonitorUsageWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JvmtiMonitorUsageWrapper(jni, pointer);
    }

    public final class JvmtiMonitorUsageWrapper
    extends StructWrapper {
        JvmtiMonitorUsageWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, JvmtiMonitorUsage.this.structSize);
        }

        public StaticObject owner() {
            return this.getObject(JvmtiMonitorUsage.this.owner);
        }

        public void owner(StaticObject valueToPut) {
            this.putObject(JvmtiMonitorUsage.this.owner, valueToPut);
        }

        public int entryCount() {
            return this.getInt(JvmtiMonitorUsage.this.entry_count);
        }

        public void entryCount(int valueToPut) {
            this.putInt(JvmtiMonitorUsage.this.entry_count, valueToPut);
        }

        public int waiterCount() {
            return this.getInt(JvmtiMonitorUsage.this.waiter_count);
        }

        public void waiterCount(int valueToPut) {
            this.putInt(JvmtiMonitorUsage.this.waiter_count, valueToPut);
        }

        public TruffleObject waiters() {
            return this.getPointer(JvmtiMonitorUsage.this.waiters);
        }

        public void waiters(TruffleObject valueToPut) {
            this.putPointer(JvmtiMonitorUsage.this.waiters, valueToPut);
        }

        public int notifyWaiterCount() {
            return this.getInt(JvmtiMonitorUsage.this.notify_waiter_count);
        }

        public void notifyWaiterCount(int valueToPut) {
            this.putInt(JvmtiMonitorUsage.this.notify_waiter_count, valueToPut);
        }

        public TruffleObject notifyWaiters() {
            return this.getPointer(JvmtiMonitorUsage.this.notify_waiters);
        }

        public void notifyWaiters(TruffleObject valueToPut) {
            this.putPointer(JvmtiMonitorUsage.this.notify_waiters, valueToPut);
        }
    }
}

