/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.structs;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.vm.structs.MemberOffsetGetter;
import com.oracle.truffle.espresso.vm.structs.StructStorage;
import com.oracle.truffle.espresso.vm.structs.StructWrapper;

public final class JvmtiLineNumberEntry
extends StructStorage<JvmtiLineNumberEntryWrapper> {
    final int start_location;
    final int line_number;

    JvmtiLineNumberEntry(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiLineNumberEntry"));
        this.start_location = (int)offsetGetter.getOffset("_jvmtiLineNumberEntry", "start_location");
        this.line_number = (int)offsetGetter.getOffset("_jvmtiLineNumberEntry", "line_number");
    }

    @Override
    public JvmtiLineNumberEntryWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JvmtiLineNumberEntryWrapper(jni, pointer);
    }

    public final class JvmtiLineNumberEntryWrapper
    extends StructWrapper {
        JvmtiLineNumberEntryWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, JvmtiLineNumberEntry.this.structSize);
        }

        public long startLocation() {
            return this.getLong(JvmtiLineNumberEntry.this.start_location);
        }

        public void startLocation(long valueToPut) {
            this.putLong(JvmtiLineNumberEntry.this.start_location, valueToPut);
        }

        public int lineNumber() {
            return this.getInt(JvmtiLineNumberEntry.this.line_number);
        }

        public void lineNumber(int valueToPut) {
            this.putInt(JvmtiLineNumberEntry.this.line_number, valueToPut);
        }
    }
}

