/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.npe;

import com.oracle.truffle.espresso.vm.npe.StackObject;
import com.oracle.truffle.espresso.vm.npe.StackType;

final class SimulatedStack {
    final StackObject[] stack;
    int top = 0;
    long writtenLocalSlots = 0L;

    SimulatedStack(int maxStack) {
        this.stack = new StackObject[maxStack];
    }

    SimulatedStack(SimulatedStack copy) {
        this(copy, copy.size());
    }

    SimulatedStack(SimulatedStack copy, int requestedLength) {
        assert (requestedLength >= copy.size());
        StackObject[] newStack = new StackObject[requestedLength];
        System.arraycopy(copy.stack, 0, newStack, 0, copy.size());
        this.stack = newStack;
        this.top = copy.top;
        this.writtenLocalSlots = copy.writtenLocalSlots;
    }

    static SimulatedStack merge(SimulatedStack s1, SimulatedStack s2) {
        if (s1 == null) {
            return new SimulatedStack(s2);
        }
        if (s2 == null) {
            return new SimulatedStack(s1);
        }
        SimulatedStack merge = new SimulatedStack(s1.size());
        assert (s1.size() == s2.size()) : "Verifier guarantee failed for stack sizes: " + s1.size() + " != " + s2.size();
        for (int i = 0; i < s1.size(); ++i) {
            merge.put(i, StackObject.merge(s1.get(i), s2.get(i)));
        }
        merge.top = s1.size();
        merge.writtenLocalSlots = s1.writtenLocalSlots | s2.writtenLocalSlots;
        return merge;
    }

    SimulatedStack push(int bci, StackType type) {
        if (type == StackType.VOID) {
            return this;
        }
        return this.push(StackObject.create(bci, type));
    }

    SimulatedStack pushRaw(StackObject obj) {
        this.stack[this.top++] = obj;
        return this;
    }

    private SimulatedStack push(StackObject obj) {
        this.pushRaw(obj);
        if (obj.type().hasTwoSlots()) {
            this.pushRaw(obj);
        }
        return this;
    }

    StackObject pop() {
        return this.stack[--this.top];
    }

    void pop(int n) {
        for (int i = 0; i < n; ++i) {
            this.pop();
        }
    }

    int size() {
        return this.top;
    }

    void setLocalSlotWritten(int at) {
        if (at < 64) {
            this.writtenLocalSlots |= 1L << at;
        }
    }

    boolean isLocalSlotWritten(int at) {
        if (at < 64) {
            return (this.writtenLocalSlots & 1L << at) != 0L;
        }
        return true;
    }

    StackObject top(int at) {
        return this.stack[this.top - 1 - at];
    }

    private StackObject get(int at) {
        return this.stack[at];
    }

    private void put(int at, StackObject obj) {
        this.stack[at] = obj;
    }
}

