/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Target_java_lang_invoke_MethodHandleNatives;
import com.oracle.truffle.espresso.vm.VM;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class StackWalk {
    private final AtomicLong walkerIds = new AtomicLong(1L);
    private final Map<Long, FrameWalker> walkers = new ConcurrentHashMap<Long, FrameWalker>();
    private static final long DEFAULT_MODE = 0L;
    private static final long FILL_CLASS_REFS_ONLY = 2L;
    private static final long GET_CALLER_CLASS = 4L;
    private static final long SHOW_HIDDEN_FRAMES = 32L;
    private static final long FILL_LIVE_STACK_FRAMES = 256L;

    static boolean getCallerClass(long mode) {
        return (mode & 4L) != 0L;
    }

    static boolean skipHiddenFrames(long mode) {
        return (mode & 0x20L) == 0L;
    }

    static boolean liveFrameInfo(long mode) {
        return (mode & 0x100L) != 0L;
    }

    static boolean needMethodInfo(long mode) {
        return (mode & 2L) == 0L;
    }

    private static boolean synchronizedConstants(Meta meta) {
        ObjectKlass stackStreamFactory = meta.java_lang_StackStreamFactory;
        StaticObject statics = stackStreamFactory.tryInitializeAndGetStatics();
        assert (0L == (long)StackWalk.getConstantField(stackStreamFactory, statics, "DEFAULT_MODE", meta));
        assert (2L == (long)StackWalk.getConstantField(stackStreamFactory, statics, "FILL_CLASS_REFS_ONLY", meta));
        assert (4L == (long)StackWalk.getConstantField(stackStreamFactory, statics, "GET_CALLER_CLASS", meta));
        assert (32L == (long)StackWalk.getConstantField(stackStreamFactory, statics, "SHOW_HIDDEN_FRAMES", meta));
        assert (256L == (long)StackWalk.getConstantField(stackStreamFactory, statics, "FILL_LIVE_STACK_FRAMES", meta));
        return true;
    }

    private static int getConstantField(Klass stackStreamFactory, StaticObject statics, String name, Meta meta) {
        return stackStreamFactory.lookupDeclaredField(meta.getNames().getOrCreate(name), Symbol.Type._int).getInt(statics);
    }

    public StaticObject fetchFirstBatch(@JavaType(internalName="Ljava/lang/StackStreamFactory;") StaticObject stackStream, long mode, int skipframes, int batchSize, int startIndex, @JavaType(value=Object[].class) StaticObject frames, Meta meta) {
        int decoded;
        assert (StackWalk.synchronizedConstants(meta));
        FrameWalker fw = new FrameWalker(meta, mode);
        fw.init(skipframes, batchSize, startIndex);
        Integer decodedOrNull = fw.doStackWalk(frames);
        int n = decoded = decodedOrNull == null ? fw.decoded() : decodedOrNull.intValue();
        if (decoded < 1) {
            throw meta.throwException(meta.java_lang_InternalError);
        }
        this.register(fw);
        Object result = meta.java_lang_StackStreamFactory_AbstractStackWalker_doStackWalk.invokeDirect(stackStream, fw.anchor, skipframes, batchSize, startIndex, startIndex + decoded);
        this.unAnchor(fw);
        return (StaticObject)result;
    }

    public int fetchNextBatch(@JavaType(internalName="Ljava/lang/StackStreamFactory;") StaticObject stackStream, long mode, long anchor, int batchSize, int startIndex, @JavaType(value=Object[].class) StaticObject frames, Meta meta) {
        assert (StackWalk.synchronizedConstants(meta));
        FrameWalker fw = this.getAnchored(anchor);
        if (fw == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "doStackWalk: corrupted buffers");
        }
        if (batchSize <= 0) {
            return startIndex;
        }
        fw.next(batchSize, startIndex);
        fw.mode(mode);
        Integer decodedOrNull = fw.doStackWalk(frames);
        int decoded = decodedOrNull == null ? fw.decoded() : decodedOrNull.intValue();
        return startIndex + decoded;
    }

    private void register(FrameWalker fw) {
        this.walkers.put(fw.anchor, fw);
    }

    private FrameWalker getAnchored(long id) {
        return this.walkers.get(id);
    }

    private void unAnchor(FrameWalker fw) {
        this.walkers.remove(fw.anchor);
    }

    class FrameWalker
    implements FrameInstanceVisitor<Integer> {
        protected final Meta meta;
        protected long mode;
        private volatile long anchor = -1L;
        private int state = 0;
        private int from = 0;
        private int batchSize = 0;
        private int startIndex = 0;
        private StaticObject frames = StaticObject.NULL;
        private int depth = 0;
        private int decoded = 0;
        private static final int LOCATE_CALLSTACKWALK = 0;
        private static final int LOCATE_STACK_BEGIN = 1;
        private static final int LOCATE_FROM = 2;
        private static final int PROCESS = 3;
        private static final int HALT = 4;

        FrameWalker(Meta meta, long mode) {
            this.meta = meta;
            this.mode = mode;
        }

        public void anchor() {
            assert (!this.isAnchored());
            this.anchor = StackWalk.this.walkerIds.getAndIncrement();
        }

        public boolean isAnchored() {
            return this.anchor > 0L;
        }

        public int decoded() {
            return this.decoded;
        }

        public void clear() {
            this.state = 0;
            this.depth = 0;
            this.decoded = 0;
        }

        public void init(int skipFrames, int firstBatchSize, int firstStartIndex) {
            this.from = skipFrames;
            this.batchSize = firstBatchSize;
            this.startIndex = firstStartIndex;
        }

        public void next(int newBatchSize, int newStartIndex) {
            this.from = this.depth;
            this.batchSize = newBatchSize;
            this.startIndex = newStartIndex;
        }

        public void mode(long toSet) {
            this.mode = toSet;
        }

        public Integer doStackWalk(StaticObject usedFrames) {
            this.clear();
            this.frames = usedFrames;
            Integer res = (Integer)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)this);
            this.frames = StaticObject.NULL;
            return res;
        }

        private boolean isFromStackWalkingAPI(Method m) {
            return m.getDeclaringKlass() == this.meta.java_lang_StackWalker || m.getDeclaringKlass() == this.meta.java_lang_StackStreamFactory_AbstractStackWalker || m.getDeclaringKlass().getSuperKlass() == this.meta.java_lang_StackStreamFactory_AbstractStackWalker;
        }

        private boolean isCallStackWalk(Method m) {
            return m.getDeclaringKlass() == this.meta.java_lang_StackStreamFactory_AbstractStackWalker && Symbol.Name.callStackWalk.equals(m.getName()) && this.getCallStackWalkSignature().equals(m.getRawSignature());
        }

        private Symbol<Symbol.Signature> getCallStackWalkSignature() {
            return this.meta.getJavaVersion().java19OrLater() ? Symbol.Signature.Object_long_int_ContinuationScope_Continuation_int_int_Object_array : Symbol.Signature.Object_long_int_int_int_Object_array;
        }

        public Integer visitFrame(FrameInstance frameInstance) {
            Method m;
            EspressoRootNode root = VM.getEspressoRootFromFrame(frameInstance, this.meta.getContext());
            Method method = m = root == null ? null : root.getMethod();
            if (m != null) {
                switch (this.state) {
                    case 0: {
                        if (!this.isCallStackWalk(m)) break;
                        if (this.isAnchored()) {
                            if (root.readStackAnchorOrZero(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY)) != this.anchor) {
                                break;
                            }
                        } else {
                            this.anchor();
                            root.setStackWalkAnchor(frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE), this.anchor);
                        }
                        this.state = 1;
                    }
                    case 1: {
                        if (this.isFromStackWalkingAPI(m)) break;
                        this.state = 2;
                    }
                    case 2: {
                        if (this.depth < this.from) {
                            ++this.depth;
                            break;
                        }
                        this.state = 3;
                    }
                    case 3: {
                        if (this.decoded >= this.batchSize) {
                            this.state = 4;
                            return this.decoded;
                        }
                        this.tryProcessFrame(frameInstance, m, this.startIndex + this.decoded);
                        ++this.depth;
                        if (this.decoded < this.batchSize) break;
                        this.state = 4;
                        return this.decoded;
                    }
                    default: {
                        throw EspressoError.shouldNotReachHere();
                    }
                }
            }
            return null;
        }

        private void tryProcessFrame(FrameInstance frameInstance, Method m, int index) {
            if ((StackWalk.getCallerClass(this.mode) || StackWalk.skipHiddenFrames(this.mode)) && m.isHidden()) {
                return;
            }
            if (!StackWalk.needMethodInfo(this.mode) && StackWalk.getCallerClass(this.mode) && index == this.startIndex && m.isCallerSensitive()) {
                throw this.meta.throwExceptionWithMessage(this.meta.java_lang_UnsupportedOperationException, "StackWalker::getCallerClass called from @CallerSensitive " + m.getNameAsString() + " method");
            }
            this.processFrame(frameInstance, m, index);
            ++this.decoded;
        }

        private void processFrame(FrameInstance frameInstance, Method m, int index) {
            if (StackWalk.liveFrameInfo(this.mode)) {
                this.fillFrame(frameInstance, m, index);
                throw EspressoError.unimplemented();
            }
            if (StackWalk.needMethodInfo(this.mode)) {
                this.fillFrame(frameInstance, m, index);
            } else {
                ObjectKlass klass = m.getDeclaringKlass();
                this.meta.getInterpreterToVM().setArrayObject(klass.getContext().getLanguage(), klass.mirror(), index, this.frames);
            }
        }

        private void fillFrame(FrameInstance frameInstance, Method m, int index) {
            StaticObject frame = (StaticObject)this.frames.get(this.meta.getLanguage(), index);
            StaticObject memberName = this.meta.java_lang_StackFrameInfo_memberName.getObject(frame);
            Target_java_lang_invoke_MethodHandleNatives.plantResolvedMethod(memberName, m, m.getRefKind(), this.meta);
            this.meta.java_lang_invoke_MemberName_clazz.setObject(memberName, m.getDeclaringKlass().mirror());
            EspressoRootNode rootNode = VM.getEspressoRootFromFrame(frameInstance, this.meta.getContext());
            this.meta.java_lang_StackFrameInfo_bci.setInt(frame, rootNode.readBCI(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY)));
        }
    }
}

