/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.verifier.Operand;
import com.oracle.truffle.espresso.verifier.ReferenceOperand;

final class UninitReferenceOperand
extends ReferenceOperand {
    final int newBCI;

    UninitReferenceOperand(Symbol<Symbol.Type> type, Klass thisKlass) {
        super(type, thisKlass);
        this.newBCI = -1;
    }

    UninitReferenceOperand(Symbol<Symbol.Type> type, Klass thisKlass, int newBCI) {
        super(type, thisKlass);
        this.newBCI = newBCI;
    }

    UninitReferenceOperand(Klass klass, Klass thisKlass) {
        super(klass, thisKlass);
        this.newBCI = -1;
    }

    @Override
    boolean isUninit() {
        return true;
    }

    @Override
    boolean compliesWithInMerge(Operand other) {
        if (other.isUninit()) {
            return this.compliesWith(other);
        }
        return other.isTopOperand();
    }

    @Override
    Operand mergeWith(Operand other) {
        if (other.isUninit()) {
            return super.mergeWith(other);
        }
        return null;
    }

    ReferenceOperand init() {
        if (this.klass == null) {
            return new ReferenceOperand(this.type, this.thisKlass);
        }
        return new ReferenceOperand(this.klass, this.thisKlass);
    }

    @Override
    boolean isUninitThis() {
        return this.newBCI == -1;
    }
}

