/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.verifier.Locals;
import com.oracle.truffle.espresso.verifier.MethodVerifier;
import com.oracle.truffle.espresso.verifier.Operand;
import com.oracle.truffle.espresso.verifier.OperandStack;
import com.oracle.truffle.espresso.verifier.SubroutineModificationStack;

class StackFrame {
    final Operand[] stack;
    final int stackSize;
    final int top;
    final Operand[] locals;
    final SubroutineModificationStack subroutineModificationStack;
    int lastLocal;

    StackFrame(OperandStack stack, Locals locals) {
        this.stack = stack.extract();
        this.stackSize = stack.size;
        this.top = stack.top;
        this.locals = locals.extract();
        this.subroutineModificationStack = locals.subRoutineModifications;
    }

    StackFrame(OperandStack stack, Operand[] locals) {
        this.stack = stack.extract();
        this.stackSize = stack.size;
        this.top = stack.top;
        this.locals = locals;
        this.subroutineModificationStack = null;
    }

    StackFrame(OperandStack stack, Operand[] locals, SubroutineModificationStack sms) {
        this.stack = stack.extract();
        this.stackSize = stack.size;
        this.top = stack.top;
        this.locals = locals;
        this.subroutineModificationStack = sms;
    }

    StackFrame(MethodVerifier mv) {
        this(new OperandStack(mv.getMaxStack()), new Locals(mv));
        int last = mv.isStatic() ? 0 : 1;
        for (int i = 0; i < mv.getSig().length - 1; ++i) {
            if (!MethodVerifier.isType2(this.locals[last++])) continue;
            ++last;
        }
        this.lastLocal = last - 1;
    }

    StackFrame(Operand[] stack, int stackSize, int top, Operand[] locals) {
        this.stack = stack;
        this.stackSize = stackSize;
        this.top = top;
        this.locals = locals;
        this.subroutineModificationStack = null;
    }

    StackFrame(Operand[] stack, int stackSize, int top, Operand[] locals, SubroutineModificationStack sms) {
        this.stack = stack;
        this.stackSize = stackSize;
        this.top = top;
        this.locals = locals;
        this.subroutineModificationStack = sms;
    }

    OperandStack extractStack(int maxStack) {
        OperandStack res = new OperandStack(maxStack);
        System.arraycopy(this.stack, 0, res.stack, 0, this.top);
        res.size = this.stackSize;
        res.top = this.top;
        return res;
    }

    Locals extractLocals() {
        Locals newLocals = new Locals((Operand[])this.locals.clone());
        newLocals.subRoutineModifications = this.subroutineModificationStack;
        return newLocals;
    }

    void mergeSubroutines(SubroutineModificationStack other) {
        if (this.subroutineModificationStack == null) {
            return;
        }
        if (other == this.subroutineModificationStack) {
            return;
        }
        this.subroutineModificationStack.merge(other);
    }
}

