/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.threads;

import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.threads.State;
import com.oracle.truffle.espresso.threads.ThreadsAccess;
import com.oracle.truffle.espresso.threads.Transition;

final class NativeToGuestTransition
implements Transition {
    private final ThreadsAccess access;
    private final int old;
    private final StaticObject thread;

    NativeToGuestTransition(EspressoContext context) {
        this.access = context.getThreadAccess();
        this.thread = context.getCurrentPlatformThread();
        this.old = this.access.getState(this.thread);
        assert ((this.old & State.IN_NATIVE.value) != 0);
        this.access.setState(this.thread, State.RUNNABLE.value);
    }

    @Override
    public void close() {
        this.access.restoreState(this.thread, this.old);
    }
}

