/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNamesProvider;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;

@EspressoSubstitutions(nameProvider=SharedNativeMetohdAccessorImpl.class)
public final class Target_sun_reflect_NativeMethodAccessorImpl {
    private static final String[] NAMES = new String[]{"Target_sun_reflect_NativeMethodAccessorImpl", "Target_jdk_internal_reflect_NativeMethodAccessorImpl", "Target_jdk_internal_reflect_DirectMethodHandleAccessor$NativeAccessor"};

    private Target_sun_reflect_NativeMethodAccessorImpl() {
    }

    public static Object checkAndWiden(Meta meta, StaticObject arg, Klass targetKlass) {
        if (targetKlass.isPrimitive()) {
            if (StaticObject.isNull(arg)) {
                throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "argument type mismatch");
            }
            Klass argKlass = arg.getKlass();
            switch (targetKlass.getJavaKind()) {
                case Boolean: {
                    if (argKlass != meta.java_lang_Boolean) break;
                    return meta.unboxBoolean(arg);
                }
                case Byte: {
                    if (argKlass != meta.java_lang_Byte) break;
                    return meta.unboxByte(arg);
                }
                case Char: {
                    if (argKlass != meta.java_lang_Character) break;
                    return Character.valueOf(meta.unboxCharacter(arg));
                }
                case Short: {
                    if (argKlass == meta.java_lang_Short) {
                        return meta.unboxShort(arg);
                    }
                    if (argKlass != meta.java_lang_Byte) break;
                    return (short)meta.unboxByte(arg);
                }
                case Int: {
                    if (argKlass == meta.java_lang_Integer) {
                        return meta.unboxInteger(arg);
                    }
                    if (argKlass == meta.java_lang_Byte) {
                        return (int)meta.unboxByte(arg);
                    }
                    if (argKlass == meta.java_lang_Character) {
                        return (int)meta.unboxCharacter(arg);
                    }
                    if (argKlass != meta.java_lang_Short) break;
                    return (int)meta.unboxShort(arg);
                }
                case Float: {
                    if (argKlass == meta.java_lang_Float) {
                        return Float.valueOf(meta.unboxFloat(arg));
                    }
                    if (argKlass == meta.java_lang_Byte) {
                        return Float.valueOf(meta.unboxByte(arg));
                    }
                    if (argKlass == meta.java_lang_Character) {
                        return Float.valueOf(meta.unboxCharacter(arg));
                    }
                    if (argKlass == meta.java_lang_Short) {
                        return Float.valueOf(meta.unboxShort(arg));
                    }
                    if (argKlass == meta.java_lang_Integer) {
                        return Float.valueOf(meta.unboxInteger(arg));
                    }
                    if (argKlass != meta.java_lang_Long) break;
                    return Float.valueOf(meta.unboxLong(arg));
                }
                case Long: {
                    if (argKlass == meta.java_lang_Long) {
                        return meta.unboxLong(arg);
                    }
                    if (argKlass == meta.java_lang_Integer) {
                        return (long)meta.unboxInteger(arg);
                    }
                    if (argKlass == meta.java_lang_Byte) {
                        return (long)meta.unboxByte(arg);
                    }
                    if (argKlass == meta.java_lang_Character) {
                        return (long)meta.unboxCharacter(arg);
                    }
                    if (argKlass != meta.java_lang_Short) break;
                    return (long)meta.unboxShort(arg);
                }
                case Double: {
                    if (argKlass == meta.java_lang_Double) {
                        return meta.unboxDouble(arg);
                    }
                    if (argKlass == meta.java_lang_Float) {
                        return (double)meta.unboxFloat(arg);
                    }
                    if (argKlass == meta.java_lang_Integer) {
                        return (double)meta.unboxInteger(arg);
                    }
                    if (argKlass == meta.java_lang_Byte) {
                        return (double)meta.unboxByte(arg);
                    }
                    if (argKlass == meta.java_lang_Character) {
                        return (double)meta.unboxCharacter(arg);
                    }
                    if (argKlass == meta.java_lang_Short) {
                        return (double)meta.unboxShort(arg);
                    }
                    if (argKlass != meta.java_lang_Long) break;
                    return (double)meta.unboxLong(arg);
                }
            }
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "argument type mismatch");
        }
        if (StaticObject.notNull(arg) && !targetKlass.isAssignableFrom(arg.getKlass())) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "argument type mismatch");
        }
        return arg;
    }

    static @JavaType(value=Object.class) StaticObject invoke0(@JavaType(value=java.lang.reflect.Method.class) StaticObject guestMethod, @JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object[].class) StaticObject args, @Inject EspressoLanguage language, @Inject Meta meta, ToEspressoNode.DynamicToEspresso toEspressoNode) {
        Method reflectedMethod = Method.getHostReflectiveMethodRoot(guestMethod, meta);
        Klass klass = meta.java_lang_reflect_Method_clazz.getObject(guestMethod).getMirrorKlass(meta);
        if (klass == meta.java_lang_invoke_MethodHandle && (reflectedMethod.getName() == Symbol.Name.invoke || reflectedMethod.getName() == Symbol.Name.invokeExact)) {
            StaticObject cause = Meta.initExceptionWithMessage(meta.java_lang_UnsupportedOperationException, "Cannot reflectively invoke MethodHandle.{invoke,invokeExact}");
            StaticObject invocationTargetException = Meta.initExceptionWithCause(meta.java_lang_reflect_InvocationTargetException, cause);
            throw meta.throwException(invocationTargetException);
        }
        StaticObject parameterTypes = meta.java_lang_reflect_Method_parameterTypes.getObject(guestMethod);
        return Target_sun_reflect_NativeMethodAccessorImpl.callMethodReflectively(language, meta, receiver, args, reflectedMethod, klass, parameterTypes, toEspressoNode);
    }

    public static @JavaType(value=Object.class) StaticObject callMethodReflectively(EspressoLanguage language, Meta meta, @JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object[].class) StaticObject args, Method m, Klass klass, @JavaType(value=Class[].class) StaticObject parameterTypes, ToEspressoNode.DynamicToEspresso toEspressoNode) {
        Object result;
        int argsLen;
        Method method;
        klass.safeInitialize();
        Method reflectedMethod = m;
        if (reflectedMethod.isRemovedByRedefinition()) {
            try {
                reflectedMethod = m.getContext().getClassRedefinition().handleRemovedMethod(reflectedMethod, reflectedMethod.isStatic() ? reflectedMethod.getDeclaringKlass() : receiver.getKlass());
            }
            catch (EspressoException e) {
                throw meta.throwExceptionWithCause(meta.java_lang_reflect_InvocationTargetException, e.getGuestException());
            }
        }
        if (reflectedMethod.isStatic()) {
            method = reflectedMethod;
        } else {
            if (StaticObject.isNull(receiver)) {
                throw meta.throwNullPointerException();
            }
            if (!klass.isAssignableFrom(receiver.getKlass())) {
                throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "object is not an instance of declaring class");
            }
            Klass targetKlass = receiver.getKlass();
            if (reflectedMethod.isPrivate() || Symbol.Name._init_.equals(reflectedMethod.getName())) {
                method = reflectedMethod;
            } else if (reflectedMethod.getDeclaringKlass().isInterface()) {
                method = reflectedMethod;
                assert (targetKlass instanceof ObjectKlass);
                if ((method = ((ObjectKlass)targetKlass).itableLookup(method.getDeclaringKlass(), method.getITableIndex())) != null && !method.hasCode()) {
                    throw meta.throwExceptionWithCause(meta.java_lang_reflect_InvocationTargetException, Meta.initException(meta.java_lang_AbstractMethodError));
                }
            } else {
                method = reflectedMethod;
                if ((method = targetKlass.vtableLookup(method.getVTableIndex())) != null && method.isAbstract()) {
                    throw meta.throwExceptionWithCause(meta.java_lang_reflect_InvocationTargetException, Meta.initException(meta.java_lang_AbstractMethodError));
                }
            }
        }
        if (method == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, "please let Karen know");
        }
        boolean isForeignArray = args.isForeignObject();
        Object rawForeign = null;
        InteropLibrary interop = null;
        if (isForeignArray) {
            rawForeign = args.rawForeignObject(language);
            interop = InteropLibrary.getUncached((Object)rawForeign);
            try {
                argsLen = (int)interop.getArraySize(rawForeign);
            }
            catch (UnsupportedMessageException e) {
                throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "unexpected foreign object!");
            }
        } else {
            argsLen = StaticObject.isNull(args) ? 0 : args.length(language);
        }
        Symbol<Symbol.Type>[] signature = method.getParsedSignature();
        if (Signatures.parameterCount(signature) != argsLen) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "wrong number of arguments!");
        }
        Object[] adjustedArgs = new Object[argsLen];
        for (int i = 0; i < argsLen; ++i) {
            StaticObject paramTypeMirror = (StaticObject)parameterTypes.get(language, i);
            Klass paramKlass = paramTypeMirror.getMirrorKlass(meta);
            if (isForeignArray) {
                try {
                    adjustedArgs[i] = toEspressoNode.execute(interop.readArrayElement(rawForeign, (long)i), paramKlass);
                    continue;
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "unable to read argument from foreign object!");
                }
            }
            Object arg = args.get(language, i);
            adjustedArgs[i] = Target_sun_reflect_NativeMethodAccessorImpl.checkAndWiden(meta, (StaticObject)arg, paramKlass);
        }
        try {
            result = method.invokeDirect(receiver, adjustedArgs);
        }
        catch (EspressoException e) {
            throw meta.throwExceptionWithCause(meta.java_lang_reflect_InvocationTargetException, e.getGuestException());
        }
        if (reflectedMethod.getReturnKind() == JavaKind.Void) {
            return StaticObject.NULL;
        }
        if (reflectedMethod.getReturnKind().isPrimitive()) {
            return Meta.box(meta, result);
        }
        return (StaticObject)result;
    }

    public static class SharedNativeMetohdAccessorImpl
    extends SubstitutionNamesProvider {
        public static SubstitutionNamesProvider INSTANCE = new SharedNativeMetohdAccessorImpl();

        @Override
        public String[] substitutionClassNames() {
            return NAMES;
        }
    }

    @Substitution(methodName="invoke0")
    static abstract class Invoke0
    extends SubstitutionNode {
        Invoke0() {
        }

        public abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=java.lang.reflect.Method.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, @JavaType(value=Object[].class) StaticObject var3, @Inject EspressoLanguage var4, @Inject Meta var5);

        @Specialization
        public @JavaType(value=Object.class) StaticObject invoke(@JavaType(value=java.lang.reflect.Method.class) StaticObject guestMethod, @JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Object[].class) StaticObject args, @Inject EspressoLanguage language, @Inject Meta meta, @Cached ToEspressoNode.DynamicToEspresso toEspressoNode) {
            return Target_sun_reflect_NativeMethodAccessorImpl.invoke0(guestMethod, receiver, args, language, meta, toEspressoNode);
        }
    }
}

