/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;

@EspressoSubstitutions
public final class Target_sun_launcher_LauncherHelper {
    private static final String helpMessage = "Additional Java-on-Truffle commands:\n    --polyglot    Run with all other guest languages accessible.\n    --native      Run using the native launcher with limited access to Java libraries (default).\n    --jvm         Run on the Java Virtual Machine with access to Java libraries (Unsupported).\n    --vm.[option] Pass options to the host VM. To see available options, use '--help:vm'.\n    --log.file=<String>\n                  Redirect guest languages logging into a given file.\n    --log.[logger].level=<String>\n                  Set language log level to OFF, SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST or ALL.\n    --version:graalvm\n                  Print GraalVM version information and exit.\n    --show-version:graalvm\n                  Print GraalVM version information and continue execution.\n    --help:vm     Print options for the host VM.\n    --help:languages\n                  Print options for all installed languages.\n    --help:tools  Print options for all installed tools.\n    --help:engine Print options for the Truffle engine.\n    --help:expert Print additional options for experts.\n    --help:internal\n                  Print internal options for debugging language implementations and tools.";

    @Substitution
    static abstract class PrintHelpMessage
    extends SubstitutionNode {
        PrintHelpMessage() {
        }

        abstract void execute(boolean var1);

        @Specialization
        void doCached(boolean printToStderr, @Bind(value="getMeta()") Meta meta, @Cached(value="create(meta.sun_launcher_LauncherHelper_printHelpMessage.getCallTargetNoSubstitution())") DirectCallNode originalPrintHelpMessage, @Cached(value="create(meta.java_io_PrintStream_println.getCallTarget())") DirectCallNode println) {
            originalPrintHelpMessage.call(new Object[]{printToStderr});
            StaticObject stream = meta.sun_launcher_LauncherHelper_ostream.getObject(meta.sun_launcher_LauncherHelper.tryInitializeAndGetStatics());
            if (!StaticObject.isNull(stream)) {
                println.call(new Object[]{stream, meta.toGuestString(Target_sun_launcher_LauncherHelper.helpMessage)});
            }
        }
    }
}

