/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PrimitiveKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOf;
import com.oracle.truffle.espresso.nodes.interop.MethodArgsUtils;
import com.oracle.truffle.espresso.nodes.interop.ToReference;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import java.util.Set;

@EspressoSubstitutions
public final class Target_com_oracle_truffle_espresso_polyglot_Polyglot {
    @Substitution(isTrivial=true)
    public static boolean isForeignObject(@JavaType(value=Object.class) StaticObject object) {
        return object.isForeignObject();
    }

    @CompilerDirectives.TruffleBoundary
    private static EspressoException rethrowExceptionAsEspresso(ObjectKlass exceptionKlass, String additionalMessage, Throwable originalException) {
        throw exceptionKlass.getMeta().throwExceptionWithMessage(exceptionKlass, additionalMessage + originalException.getMessage());
    }

    @CompilerDirectives.TruffleBoundary
    private static Source getSource(String languageId, String code) {
        return Source.newBuilder((String)languageId, (CharSequence)code, (String)"(eval)").build();
    }

    @CompilerDirectives.TruffleBoundary
    private static void validateLanguage(String languageId, Meta meta) {
        Set publicLanguages = meta.getContext().getEnv().getPublicLanguages().keySet();
        if (!publicLanguages.contains(languageId)) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "No language for id " + languageId + " found. Supported languages are: " + String.valueOf(publicLanguages));
        }
    }

    @Substitution
    public static @JavaType(value=Object.class) StaticObject eval(@JavaType(value=String.class) StaticObject language, @JavaType(value=String.class) StaticObject code, @Inject Meta meta) {
        Object evalResult;
        CallTarget callTarget;
        String languageId = meta.toHostString(language);
        Target_com_oracle_truffle_espresso_polyglot_Polyglot.validateLanguage(languageId, meta);
        Source source = Target_com_oracle_truffle_espresso_polyglot_Polyglot.getSource(languageId, meta.toHostString(code));
        try {
            callTarget = meta.getContext().getEnv().parsePublic(source, new String[0]);
        }
        catch (Exception e) {
            throw Target_com_oracle_truffle_espresso_polyglot_Polyglot.rethrowExceptionAsEspresso(meta.java_lang_IllegalArgumentException, "Error when parsing the source: ", e);
        }
        try {
            evalResult = callTarget.call(new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof AbstractTruffleException) {
                throw Target_com_oracle_truffle_espresso_polyglot_Polyglot.rethrowExceptionAsEspresso(meta.java_lang_RuntimeException, "Exception during evaluation: ", e);
            }
            throw e;
        }
        if (evalResult instanceof StaticObject) {
            return (StaticObject)evalResult;
        }
        return Target_com_oracle_truffle_espresso_polyglot_Polyglot.createForeignObject(evalResult, meta, InteropLibrary.getUncached());
    }

    @Substitution
    public static @JavaType(value=Object.class) StaticObject importObject(@JavaType(value=String.class) StaticObject name, @Inject Meta meta) {
        if (!meta.getContext().getEnv().isPolyglotBindingsAccessAllowed()) {
            throw meta.throwExceptionWithMessage(meta.java_lang_SecurityException, "Polyglot bindings are not accessible for this language. Use --polyglot or allowPolyglotAccess when building the context.");
        }
        Object binding = meta.getContext().getEnv().importSymbol(name.toString());
        if (binding == null) {
            return StaticObject.NULL;
        }
        if (binding instanceof StaticObject) {
            return (StaticObject)binding;
        }
        return Target_com_oracle_truffle_espresso_polyglot_Polyglot.createForeignObject(binding, meta, InteropLibrary.getUncached());
    }

    @Substitution
    public static void exportObject(@JavaType(value=String.class) StaticObject name, @JavaType(value=Object.class) StaticObject value, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (!meta.getContext().getEnv().isPolyglotBindingsAccessAllowed()) {
            throw meta.throwExceptionWithMessage(meta.java_lang_SecurityException, "Polyglot bindings are not accessible for this language. Use --polyglot or allowPolyglotAccess when building the context.");
        }
        String bindingName = meta.toHostString(name);
        if (value.isForeignObject()) {
            meta.getContext().getEnv().exportSymbol(bindingName, value.rawForeignObject(language));
        } else {
            meta.getContext().getEnv().exportSymbol(bindingName, (Object)value);
        }
    }

    protected static StaticObject createForeignObject(Object object, Meta meta, InteropLibrary interopLibrary) {
        return StaticObject.createForeign(meta.getLanguage(), meta.java_lang_Object, object, interopLibrary);
    }

    @GenerateUncached
    static abstract class CastImpl
    extends SubstitutionNode {
        static final int LIMIT = 3;

        CastImpl() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(EspressoContext var1, Klass var2, @JavaType(value=Object.class) StaticObject var3);

        static boolean isNull(StaticObject object) {
            return StaticObject.isNull(object);
        }

        static boolean isStringKlass(EspressoContext context, Klass targetKlass) {
            return targetKlass == context.getMeta().java_lang_String;
        }

        static boolean isForeignException(EspressoContext context, Klass targetKlass) {
            Meta.PolyglotSupport polyglot = context.getMeta().polyglot;
            return polyglot != null && targetKlass == polyglot.ForeignException;
        }

        @Specialization(guards={"value.isEspressoObject()"})
        @JavaType(value=Object.class) StaticObject doEspresso(EspressoContext context, Klass targetKlass, @JavaType(value=Object.class) StaticObject value, @Cached InstanceOf.Dynamic instanceOfDynamic, @Cached BranchProfile exceptionProfile) {
            if (CastImpl.isNull(value) || instanceOfDynamic.execute(value.getKlass(), targetKlass)) {
                return value;
            }
            exceptionProfile.enter();
            Meta meta = context.getMeta();
            throw meta.throwException(meta.java_lang_ClassCastException);
        }

        @Specialization(guards={"value.isForeignObject()"})
        @JavaType(value=Object.class) StaticObject doPrimitive(EspressoContext context, PrimitiveKlass targetKlass, @JavaType(value=Object.class) StaticObject value, @Cached ToReference.DynamicToReference toEspresso, @Cached BranchProfile exceptionProfile) {
            Meta meta = context.getMeta();
            try {
                Klass boxedKlass = MethodArgsUtils.primitiveTypeToBoxedType(targetKlass);
                return toEspresso.execute(value.rawForeignObject(this.getLanguage()), boxedKlass);
            }
            catch (UnsupportedTypeException e) {
                exceptionProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Couldn't read %s value from foreign object", targetKlass.getType());
            }
        }

        @Specialization(guards={"value.isForeignObject()"})
        @JavaType(value=Object.class) StaticObject doArray(EspressoContext context, ArrayKlass targetKlass, @JavaType(value=Object.class) StaticObject value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile exceptionProfile) {
            Meta meta = context.getMeta();
            Object foreignObject = value.rawForeignObject(this.getLanguage());
            if (interop.hasArrayElements(foreignObject) || targetKlass == meta._byte_array && interop.hasBufferElements(foreignObject)) {
                return StaticObject.createForeign(meta.getLanguage(), targetKlass, foreignObject, interop);
            }
            exceptionProfile.enter();
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Cannot cast non-array value to an array type");
        }

        @Specialization(guards={"isStringKlass(context, targetKlass)", "value.isForeignObject()"})
        @JavaType(value=Object.class) StaticObject doString(EspressoContext context, ObjectKlass targetKlass, @JavaType(value=Object.class) StaticObject value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile exceptionProfile) {
            Meta meta = context.getMeta();
            try {
                return meta.toGuestString(interop.asString(value.rawForeignObject(this.getLanguage())));
            }
            catch (UnsupportedMessageException e) {
                exceptionProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Cannot cast a non-string foreign object to String");
            }
        }

        @Specialization(guards={"isForeignException(context, targetKlass)", "value.isForeignObject()"})
        @JavaType(value=Object.class) StaticObject doForeignException(EspressoContext context, ObjectKlass targetKlass, @JavaType(value=Object.class) StaticObject value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile exceptionProfile) {
            Meta meta = context.getMeta();
            Object foreignObject = value.rawForeignObject(this.getLanguage());
            if (interop.isException(foreignObject)) {
                return StaticObject.createForeignException(context, foreignObject, interop);
            }
            exceptionProfile.enter();
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Cannot cast a non-exception foreign object to ForeignException");
        }

        @Fallback
        @JavaType(value=Object.class) StaticObject doDataClassOrThrow(EspressoContext context, Klass targetKlass, @JavaType(value=Object.class) StaticObject value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached InstanceOf.Dynamic instanceOfDynamic, @Cached ToReference.DynamicToReference toEspresso, @Cached BranchProfile exceptionProfile) {
            Meta meta = context.getMeta();
            if (targetKlass.isAbstract()) {
                if (instanceOfDynamic.execute(value.getKlass(), targetKlass)) {
                    return value;
                }
                exceptionProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Invalid cast to non-array abstract class");
            }
            assert (targetKlass instanceof ObjectKlass);
            assert (value.isForeignObject());
            ObjectKlass targetObjectKlass = (ObjectKlass)targetKlass;
            try {
                if (meta.isBoxed(targetObjectKlass)) {
                    Object foreignObject = value.rawForeignObject(this.getLanguage());
                    return StaticObject.createForeign(meta.getLanguage(), targetKlass, foreignObject, interop);
                }
                return toEspresso.execute(value.rawForeignObject(this.getLanguage()), targetKlass);
            }
            catch (UnsupportedTypeException e) {
                if (instanceOfDynamic.execute(value.getKlass(), targetKlass)) {
                    return value;
                }
                exceptionProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, e.getMessage());
            }
        }
    }

    @Substitution
    static abstract class Cast
    extends SubstitutionNode {
        Cast() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Class.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        protected static InstanceOf createInstanceOf(Klass superType) {
            return InstanceOf.create(superType, true);
        }

        @Specialization(guards={"targetClass.getMirrorKlass() == cachedTargetKlass"}, limit="1")
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Class.class) StaticObject targetClass, @JavaType(value=Object.class) StaticObject value, @Cached(value="targetClass.getMirrorKlass()") Klass cachedTargetKlass, @Cached BranchProfile nullTargetClassProfile, @Cached BranchProfile reWrappingProfile, @Cached(value="createInstanceOf(cachedTargetKlass)") InstanceOf instanceOfTarget, @Cached CastImpl castImpl) {
            if (StaticObject.isNull(targetClass)) {
                nullTargetClassProfile.enter();
                Meta meta = this.getMeta();
                throw meta.throwException(meta.java_lang_NullPointerException);
            }
            if (StaticObject.isNull(value) || !value.isForeignObject() && instanceOfTarget.execute(value.getKlass())) {
                return value;
            }
            reWrappingProfile.enter();
            return castImpl.execute(this.getContext(), cachedTargetKlass, value);
        }

        @Specialization(replaces={"doCached"})
        @ReportPolymorphism.Megamorphic
        @JavaType(value=Object.class) StaticObject doGeneric(@JavaType(value=Class.class) StaticObject targetClass, @JavaType(value=Object.class) StaticObject value, @Cached InstanceOf.Dynamic instanceOfDynamic, @Cached CastImpl castImpl) {
            Meta meta = this.getMeta();
            if (StaticObject.isNull(targetClass)) {
                throw meta.throwException(meta.java_lang_NullPointerException);
            }
            if (StaticObject.isNull(value) || !value.isForeignObject() && instanceOfDynamic.execute(value.getKlass(), targetClass.getMirrorKlass(meta))) {
                return value;
            }
            return castImpl.execute(this.getContext(), targetClass.getMirrorKlass(meta), value);
        }
    }
}

