/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama.aarch64;

import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.panama.StorageType;

public final class AArch64StorageType
extends Enum<AArch64StorageType>
implements StorageType {
    public static final /* enum */ AArch64StorageType INTEGER = new AArch64StorageType();
    public static final /* enum */ AArch64StorageType VECTOR = new AArch64StorageType();
    public static final /* enum */ AArch64StorageType STACK = new AArch64StorageType();
    public static final /* enum */ AArch64StorageType PLACEHOLDER = new AArch64StorageType();
    private static final int STORAGE_INTEGER = 0;
    private static final int STORAGE_VECTOR = 1;
    private static final int STORAGE_STACK = 2;
    private static final int STORAGE_PLACEHOLDER = 3;
    private static final /* synthetic */ AArch64StorageType[] $VALUES;

    public static AArch64StorageType[] values() {
        return (AArch64StorageType[])$VALUES.clone();
    }

    public static AArch64StorageType valueOf(String name) {
        return Enum.valueOf(AArch64StorageType.class, name);
    }

    @Override
    public boolean isPlaceholder() {
        return this == PLACEHOLDER;
    }

    @Override
    public boolean isInteger() {
        return this == INTEGER;
    }

    @Override
    public boolean isStack() {
        return this == STACK;
    }

    @Override
    public boolean isVector() {
        return this == VECTOR;
    }

    @Override
    public NativeType asNativeType(short maskOrSize, Klass type) {
        return switch (this.ordinal()) {
            case 0 -> {
                if (!$assertionsDisabled && maskOrSize != 1) {
                    throw new AssertionError();
                }
                switch (type.getJavaKind()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Int: {
                        yield NativeType.INT;
                    }
                    case Long: {
                        yield NativeType.LONG;
                    }
                    case Char: 
                    case Short: 
                    case Byte: 
                    case Boolean: {
                        throw EspressoError.shouldNotReachHere("Unexpected sub-word in INTEGER: " + String.valueOf(type));
                    }
                    case Double: 
                    case Float: 
                    case Object: 
                    case Void: 
                    case ReturnAddress: 
                    case Illegal: 
                }
                throw EspressoError.shouldNotReachHere("Unexpected kind in INTEGER: " + String.valueOf(type));
            }
            case 1 -> {
                if (!$assertionsDisabled && maskOrSize != 1) {
                    throw new AssertionError();
                }
                switch (type.getJavaKind()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Float: {
                        yield NativeType.FLOAT;
                    }
                    case Double: {
                        yield NativeType.DOUBLE;
                    }
                    case Int: 
                    case Long: 
                    case Char: 
                    case Short: 
                    case Byte: 
                    case Boolean: 
                    case Object: 
                    case Void: 
                    case ReturnAddress: 
                    case Illegal: 
                }
                throw EspressoError.shouldNotReachHere("Unexpected kind in VECTOR: " + String.valueOf(type));
            }
            case 2 -> {
                switch (type.getJavaKind()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Int: {
                        if (!$assertionsDisabled && maskOrSize != 4) {
                            throw new AssertionError(maskOrSize);
                        }
                        yield NativeType.INT;
                    }
                    case Long: {
                        if (!$assertionsDisabled && maskOrSize != 8) {
                            throw new AssertionError(maskOrSize);
                        }
                        yield NativeType.LONG;
                    }
                    case Float: {
                        if (!$assertionsDisabled && maskOrSize != 4) {
                            throw new AssertionError(maskOrSize);
                        }
                        yield NativeType.FLOAT;
                    }
                    case Double: {
                        if (!$assertionsDisabled && maskOrSize != 8) {
                            throw new AssertionError(maskOrSize);
                        }
                        yield NativeType.DOUBLE;
                    }
                    case Char: 
                    case Short: 
                    case Byte: 
                    case Boolean: {
                        throw EspressoError.shouldNotReachHere("Unexpected sub-word in STACK: " + String.valueOf(type));
                    }
                    case Object: 
                    case Void: 
                    case ReturnAddress: 
                    case Illegal: 
                }
                throw EspressoError.shouldNotReachHere("Unexpected kind in STACK: " + String.valueOf(type));
            }
            default -> throw EspressoError.shouldNotReachHere("Unsupported " + String.valueOf(this));
        };
    }

    public static StorageType get(byte id) {
        return switch (id) {
            case 0 -> INTEGER;
            case 1 -> VECTOR;
            case 2 -> STACK;
            case 3 -> PLACEHOLDER;
            default -> throw EspressoError.shouldNotReachHere("Unknown type: " + id);
        };
    }

    public byte getId() {
        return (byte)this.ordinal();
    }

    private static /* synthetic */ AArch64StorageType[] $values() {
        return new AArch64StorageType[]{INTEGER, VECTOR, STACK, PLACEHOLDER};
    }

    static {
        $VALUES = AArch64StorageType.$values();
    }
}

