/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama;

import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.runtime.panama.AbstractArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.Platform;
import com.oracle.truffle.espresso.runtime.panama.VMStorage;

public class WindowsArgumentsCalculator
extends AbstractArgumentsCalculator {
    private int globalIndex;
    private boolean inVarArg;

    public WindowsArgumentsCalculator(Platform platform, VMStorage[] callIntRegs, VMStorage[] callFloatRegs, VMStorage intReturn, VMStorage floatReturn) {
        super(platform, callIntRegs, callFloatRegs, intReturn, floatReturn);
    }

    @Override
    public int getNextInputIndex(VMStorage reg, Klass type, VMStorage nextReg, Klass nextType) {
        assert (WindowsArgumentsCalculator.isInt(type) || WindowsArgumentsCalculator.isFloat(type)) : this.platform.toString(reg) + ": " + String.valueOf(type);
        if (this.inVarArg) {
            if (this.skipExtraVarArgMove(reg, type)) {
                return -2;
            }
            this.inVarArg = false;
        } else if (this.isVarArg(reg, type, nextReg, nextType)) {
            this.inVarArg = true;
            if (this.skipExtraVarArgMove(reg, type)) {
                return -2;
            }
        }
        if (this.globalIndex < this.callIntRegs.length && this.callIntRegs[this.globalIndex].equals(reg)) {
            assert (WindowsArgumentsCalculator.isInt(type)) : this.platform.toString(reg) + ": " + String.valueOf(type);
            return this.globalIndex++;
        }
        if (this.globalIndex < this.callFloatRegs.length && this.callFloatRegs[this.globalIndex].equals(reg)) {
            assert (WindowsArgumentsCalculator.isFloat(type)) : this.platform.toString(reg) + ": " + String.valueOf(type);
            return this.globalIndex++;
        }
        if (reg.type(this.platform).isStack()) {
            assert (!WindowsArgumentsCalculator.isInt(type) || this.globalIndex >= this.callIntRegs.length) : this.platform.toString(reg) + ": " + String.valueOf(type);
            assert (!WindowsArgumentsCalculator.isFloat(type) || this.globalIndex >= this.callFloatRegs.length) : this.platform.toString(reg) + ": " + String.valueOf(type);
            return this.globalIndex++;
        }
        return -1;
    }

    @Override
    public boolean checkReturn(VMStorage reg, Klass type) {
        if (this.intReturn.equals(reg)) {
            assert (WindowsArgumentsCalculator.isInt(type)) : this.platform.toString(reg) + ": " + String.valueOf(type);
            return true;
        }
        if (this.floatReturn.equals(reg)) {
            assert (WindowsArgumentsCalculator.isFloat(type)) : this.platform.toString(reg) + ": " + String.valueOf(type);
            return true;
        }
        return false;
    }

    private boolean skipExtraVarArgMove(VMStorage reg, Klass type) {
        return WindowsArgumentsCalculator.isFloat(type) && reg.type(this.platform).isInteger();
    }

    @Override
    public boolean isVarArg(VMStorage reg, Klass type, VMStorage nextReg, Klass nextType) {
        if (nextReg == null) {
            return false;
        }
        if (this.globalIndex >= this.callIntRegs.length || this.globalIndex >= this.callFloatRegs.length) {
            return false;
        }
        return WindowsArgumentsCalculator.isFloat(type) && WindowsArgumentsCalculator.isFloat(nextType) && (this.callIntRegs[this.globalIndex].equals(reg) && this.callFloatRegs[this.globalIndex].equals(nextReg) || this.callIntRegs[this.globalIndex].equals(nextReg) && this.callFloatRegs[this.globalIndex].equals(reg));
    }

    public String toString() {
        return "DefaultArgumentsCalculator{platform=" + String.valueOf(this.platform) + ", globalIndex=" + this.globalIndex + "}";
    }
}

