/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.ffi.Callback;
import com.oracle.truffle.espresso.ffi.NativeAccess;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.panama.ArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.Platform;
import com.oracle.truffle.espresso.runtime.panama.StorageType;
import com.oracle.truffle.espresso.runtime.panama.VMStorage;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

public class UpcallStubs {
    private final ConcurrentHashMap<Long, UpcallStub> upcallRoots;
    private final Platform platform;
    private final NativeAccess nativeAccess;
    private final EspressoLanguage language;

    public UpcallStubs(Platform platform, NativeAccess nativeAccess, EspressoLanguage language) {
        this.platform = platform;
        this.nativeAccess = nativeAccess;
        this.language = language;
        this.upcallRoots = new ConcurrentHashMap();
    }

    @CompilerDirectives.TruffleBoundary
    public long makeStub(StaticObject mh, Method target, VMStorage[] argRegs, VMStorage[] retRegs, boolean needsReturnBuffer, long returnBufferSize) {
        UpcallStub stub = this.create(mh, target, argRegs, retRegs, needsReturnBuffer, returnBufferSize);
        long address = stub.getAddress();
        this.upcallRoots.put(address, stub);
        return address;
    }

    private UpcallStub create(StaticObject mh, Method target, VMStorage[] argRegs, VMStorage[] retRegs, boolean needsReturnBuffer, long returnBufferSize) {
        Klass[] javaPTypes = target.resolveParameterKlasses();
        Klass javaRType = target.resolveReturnKlass();
        assert (javaPTypes.length > 0);
        ArgumentsCalculator argsCalc = this.platform.getArgumentsCalculator();
        int[] shuffle = new int[javaPTypes.length - 1];
        int nativeArgsCount = javaPTypes.length - 1;
        NativeType[] nativeParamTypes = new NativeType[nativeArgsCount];
        int nativeIndex = 0;
        for (int nativeArgIndex = 0; nativeArgIndex < nativeParamTypes.length; ++nativeArgIndex) {
            Klass nextPType;
            VMStorage nextInputReg;
            int javaArgIndex = nativeArgIndex + 1;
            Klass pType = javaPTypes[javaArgIndex];
            VMStorage argReg = argRegs[nativeArgIndex];
            StorageType regType = argReg.type(this.platform);
            if (regType.isPlaceholder()) {
                switch (argReg.getStubLocation(this.platform)) {
                    default: 
                }
                throw EspressoError.unimplemented(argReg.getStubLocation(this.platform).toString());
            }
            if (nativeArgIndex + 1 < nativeParamTypes.length) {
                nextInputReg = argRegs[nativeArgIndex + 1];
                nextPType = javaPTypes[javaArgIndex + 1];
            } else {
                nextInputReg = null;
                nextPType = null;
            }
            int index = argsCalc.getNextInputIndex(argReg, pType, nextInputReg, nextPType);
            if (index >= 0) {
                shuffle[javaArgIndex - 1] = index;
                nativeParamTypes[nativeIndex] = argReg.asNativeType(this.platform, pType);
                ++nativeIndex;
                continue;
            }
            if (index == -2 || this.platform.ignoreDownCallArgument(argReg)) continue;
            throw EspressoError.shouldNotReachHere("Cannot understand argument " + nativeArgIndex + " in upcall: " + String.valueOf(argReg) + " for type " + String.valueOf(pType) + " calc: " + String.valueOf(argsCalc));
        }
        NativeType nativeReturnType = NativeType.VOID;
        if (retRegs.length > 0) {
            EspressoError.guarantee(retRegs.length == 1, "unimplemented");
            if (!argsCalc.checkReturn(retRegs[0], javaRType)) {
                throw EspressoError.shouldNotReachHere("Cannot understand out reg in downcall: " + String.valueOf(retRegs[0]) + " for type " + String.valueOf(javaRType));
            }
            nativeReturnType = retRegs[0].asNativeType(this.platform, javaRType);
        }
        NativeSignature nativeSignature = NativeSignature.create(nativeReturnType, Arrays.copyOf(nativeParamTypes, nativeIndex));
        CallTarget callTarget = target.getCallTarget();
        return new UpcallStub(callTarget, mh, shuffle, this.language, nativeArgsCount, nativeSignature, this.nativeAccess);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean freeStub(long addr) {
        return this.upcallRoots.remove(addr) != null;
    }

    public static class UpcallStub
    implements Callback.Function {
        private final TruffleObject nativeClosure;
        private final CallTarget callTarget;
        private final StaticObject mh;
        private final int[] shuffle;
        private final EspressoLanguage language;

        public UpcallStub(CallTarget callTarget, StaticObject mh, int[] shuffle, EspressoLanguage language, int nativeArgsCount, NativeSignature nativeSignature, NativeAccess nativeAccess) {
            this.callTarget = callTarget;
            this.mh = mh;
            this.shuffle = shuffle;
            this.language = language;
            this.nativeClosure = nativeAccess.createNativeClosure(new Callback(nativeArgsCount, this), nativeSignature);
        }

        public long getAddress() {
            try {
                return InteropLibrary.getUncached((Object)this.nativeClosure).asPointer((Object)this.nativeClosure);
            }
            catch (UnsupportedMessageException e) {
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Override
        public Object call(Object ... args) {
            this.language.getThreadLocalState().clearPendingException();
            return this.callTarget.call(this.processArgs(args));
        }

        @ExplodeLoop
        private Object[] processArgs(Object[] args) {
            Object[] javaArgs = new Object[args.length + 1];
            javaArgs[0] = this.mh;
            for (int i = 0; i < this.shuffle.length; ++i) {
                javaArgs[i + 1] = args[this.shuffle[i]];
            }
            return javaArgs;
        }
    }
}

