/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.jimage.decompressor;

import java.nio.ByteBuffer;

public final class CompressedIndexes {
    private static final int COMPRESSED_FLAG = 128;
    private static final int HEADER_WIDTH = 3;
    private static final int HEADER_SHIFT = 5;
    private static final int HEADER_VALUE_MASK = 31;

    private CompressedIndexes() {
    }

    public static int readInt(ByteBuffer cr) {
        byte header = cr.get();
        int size = CompressedIndexes.getHeaderLength(header);
        int result = CompressedIndexes.getHeaderValue(header);
        for (int i = 1; i < size; ++i) {
            result <<= 8;
            result |= cr.get() & 0xFF;
        }
        return result;
    }

    private static boolean isCompressed(byte b) {
        return (b & 0x80) != 0;
    }

    private static int getHeaderLength(byte b) {
        return CompressedIndexes.isCompressed(b) ? b >> 5 & 3 : 4;
    }

    private static int getHeaderValue(byte b) {
        return CompressedIndexes.isCompressed((byte)b) ? b & 0x1F : b;
    }
}

