/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInteropInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInteropInteropNodesFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;

@Collect(getter="getInstance", value={InteropNodes.class})
public final class ThrowableInteropInteropNodes
extends InteropNodes {
    private static final Factory factory = new Factory(InteropMessageFactories.dispatchToId(ThrowableInterop.class));
    private static final InteropNodes INSTANCE = new ThrowableInteropInteropNodes();

    private ThrowableInteropInteropNodes() {
        super(ThrowableInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static InteropNodes getInstance() {
        return INSTANCE;
    }

    @Override
    protected void registerMessages(Class<?> cls) {
        InteropMessageFactories.register(cls, InteropMessage.Message.GetExceptionType, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsException, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.ThrowException, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasExceptionCause, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetExceptionCause, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasExceptionMessage, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetExceptionMessage, factory, true);
    }

    static final class Factory
    implements InteropMessageFactory {
        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return this.sourceDispatch;
        }

        @Override
        public final InteropMessage create(InteropMessage.Message message) {
            switch (message) {
                case GetExceptionType: {
                    return ThrowableInteropInteropNodesFactory.GetExceptionTypeNodeGen.create();
                }
                case IsException: {
                    return ThrowableInteropInteropNodesFactory.IsExceptionNodeGen.create();
                }
                case ThrowException: {
                    return ThrowableInteropInteropNodesFactory.ThrowExceptionNodeGen.create();
                }
                case HasExceptionCause: {
                    return ThrowableInteropInteropNodesFactory.HasExceptionCauseNodeGen.create();
                }
                case GetExceptionCause: {
                    return ThrowableInteropInteropNodesFactory.GetExceptionCauseNodeGen.create();
                }
                case HasExceptionMessage: {
                    return ThrowableInteropInteropNodesFactory.HasExceptionMessageNodeGen.create();
                }
                case GetExceptionMessage: {
                    return ThrowableInteropInteropNodesFactory.GetExceptionMessageNodeGen.create();
                }
            }
            return null;
        }
    }

    static abstract class GetExceptionMessageNode
    extends InteropMessage.GetExceptionMessage {
        GetExceptionMessageNode() {
        }

        @Specialization
        static Object getExceptionMessage(StaticObject object) throws UnsupportedMessageException {
            return ThrowableInterop.getExceptionMessage(object);
        }
    }

    static abstract class HasExceptionMessageNode
    extends InteropMessage.HasExceptionMessage {
        HasExceptionMessageNode() {
        }

        @Specialization
        static boolean hasExceptionMessage(StaticObject object) {
            return ThrowableInterop.hasExceptionMessage(object);
        }
    }

    static abstract class GetExceptionCauseNode
    extends InteropMessage.GetExceptionCause {
        GetExceptionCauseNode() {
        }

        @Specialization
        static Object getExceptionCause(StaticObject object) throws UnsupportedMessageException {
            return ThrowableInterop.getExceptionCause(object);
        }
    }

    static abstract class HasExceptionCauseNode
    extends InteropMessage.HasExceptionCause {
        HasExceptionCauseNode() {
        }

        @Specialization
        static boolean hasExceptionCause(StaticObject object) {
            return ThrowableInterop.hasExceptionCause(object);
        }
    }

    static abstract class ThrowExceptionNode
    extends InteropMessage.ThrowException {
        ThrowExceptionNode() {
        }

        @Specialization
        static RuntimeException throwException(StaticObject object) {
            return ThrowableInterop.throwException(object);
        }
    }

    static abstract class IsExceptionNode
    extends InteropMessage.IsException {
        IsExceptionNode() {
        }

        @Specialization
        static boolean isException(StaticObject object) {
            return ThrowableInterop.isException(object);
        }
    }

    static abstract class GetExceptionTypeNode
    extends InteropMessage.GetExceptionType {
        GetExceptionTypeNode() {
        }

        @Specialization
        static ExceptionType getExceptionType(StaticObject receiver) throws UnsupportedMessageException {
            return ThrowableInterop.getExceptionType(receiver);
        }
    }
}

