/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.interop.LookupAndInvokeKnownMethodNode;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.IterableInteropInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ListInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ListInteropInteropNodesFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;

@Collect(getter="getInstance", value={InteropNodes.class})
public final class ListInteropInteropNodes
extends InteropNodes {
    private static final Factory factory = new Factory(InteropMessageFactories.dispatchToId(ListInterop.class));
    private static final InteropNodes INSTANCE = new ListInteropInteropNodes();

    private ListInteropInteropNodes() {
        super(ListInterop.class, IterableInteropInteropNodes.getInstance());
    }

    public static InteropNodes getInstance() {
        return INSTANCE;
    }

    @Override
    protected void registerMessages(Class<?> cls) {
        InteropMessageFactories.register(cls, InteropMessage.Message.HasArrayElements, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetArraySize, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadArrayElement, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteArrayElement, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.RemoveArrayElement, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsArrayElementReadable, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsArrayElementModifiable, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsArrayElementInsertable, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsArrayElementRemovable, factory, false);
    }

    static final class Factory
    implements InteropMessageFactory {
        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return this.sourceDispatch;
        }

        @Override
        public final InteropMessage create(InteropMessage.Message message) {
            switch (message) {
                case HasArrayElements: {
                    return ListInteropInteropNodesFactory.HasArrayElementsNodeGen.create();
                }
                case GetArraySize: {
                    return ListInteropInteropNodesFactory.GetArraySizeNodeGen.create();
                }
                case ReadArrayElement: {
                    return ListInteropInteropNodesFactory.ReadArrayElementNodeGen.create();
                }
                case WriteArrayElement: {
                    return ListInteropInteropNodesFactory.WriteArrayElementNodeGen.create();
                }
                case RemoveArrayElement: {
                    return ListInteropInteropNodesFactory.RemoveArrayElementNodeGen.create();
                }
                case IsArrayElementReadable: {
                    return ListInteropInteropNodesFactory.IsArrayElementReadableNodeGen.create();
                }
                case IsArrayElementModifiable: {
                    return ListInteropInteropNodesFactory.IsArrayElementModifiableNodeGen.create();
                }
                case IsArrayElementInsertable: {
                    return ListInteropInteropNodesFactory.IsArrayElementInsertableNodeGen.create();
                }
                case IsArrayElementRemovable: {
                    return ListInteropInteropNodesFactory.IsArrayElementRemovableNodeGen.create();
                }
            }
            return null;
        }
    }

    static abstract class IsArrayElementRemovableNode
    extends InteropMessage.IsArrayElementRemovable {
        IsArrayElementRemovableNode() {
        }

        @Specialization
        static boolean isArrayElementRemovable(StaticObject receiver, long index, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode size) {
            return ListInterop.isArrayElementRemovable(receiver, index, listSizeMethod, size);
        }
    }

    static abstract class IsArrayElementInsertableNode
    extends InteropMessage.IsArrayElementInsertable {
        IsArrayElementInsertableNode() {
        }

        @Specialization
        static boolean isArrayElementInsertable(StaticObject receiver, long index, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode size) {
            return ListInterop.isArrayElementInsertable(receiver, index, listSizeMethod, size);
        }
    }

    static abstract class IsArrayElementModifiableNode
    extends InteropMessage.IsArrayElementModifiable {
        IsArrayElementModifiableNode() {
        }

        @Specialization
        static boolean isArrayElementModifiable(StaticObject receiver, long index, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode size) {
            return ListInterop.isArrayElementModifiable(receiver, index, listSizeMethod, size);
        }
    }

    static abstract class IsArrayElementReadableNode
    extends InteropMessage.IsArrayElementReadable {
        IsArrayElementReadableNode() {
        }

        @Specialization
        static boolean isArrayElementReadable(StaticObject receiver, long index, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode size) {
            return ListInterop.isArrayElementReadable(receiver, index, listSizeMethod, size);
        }
    }

    static abstract class RemoveArrayElementNode
    extends InteropMessage.RemoveArrayElement {
        RemoveArrayElementNode() {
        }

        @Specialization
        static void removeArrayElement(StaticObject receiver, long index, @Cached(value="create($parameters)") ListInterop.ListRemove listRemove, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode size, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException, InvalidArrayIndexException {
            ListInterop.removeArrayElement(receiver, index, listRemove, listSizeMethod, size, error);
        }
    }

    static abstract class WriteArrayElementNode
    extends InteropMessage.WriteArrayElement {
        WriteArrayElementNode() {
        }

        @Specialization
        static void writeArrayElement(StaticObject receiver, long index, Object value, @Cached(value="create($parameters)") ListInterop.ListSet listSet, @Cached(value="create($parameters)") ListInterop.ListAdd listAdd, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode size, @Cached(value="create($parameters)") BranchProfile error) throws InvalidArrayIndexException, UnsupportedMessageException {
            ListInterop.writeArrayElement(receiver, index, value, listSet, listAdd, listSizeMethod, size, error);
        }
    }

    static abstract class ReadArrayElementNode
    extends InteropMessage.ReadArrayElement {
        ReadArrayElementNode() {
        }

        @Specialization
        static Object readArrayElement(StaticObject receiver, long index, @Cached(value="create($parameters)") ListInterop.ListGet listGet, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode size, @Cached(value="create($parameters)") BranchProfile error) throws InvalidArrayIndexException {
            return ListInterop.readArrayElement(receiver, index, listGet, listSizeMethod, size, error);
        }
    }

    static abstract class GetArraySizeNode
    extends InteropMessage.GetArraySize {
        GetArraySizeNode() {
        }

        @Specialization
        static long getArraySize(StaticObject receiver, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode size) {
            return ListInterop.getArraySize(receiver, listSizeMethod, size);
        }
    }

    static abstract class HasArrayElementsNode
    extends InteropMessage.HasArrayElements {
        HasArrayElementsNode() {
        }

        @Specialization
        static boolean hasArrayElements(StaticObject receiver) {
            return ListInterop.hasArrayElements(receiver);
        }
    }
}

