/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ForeignExceptionInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ForeignExceptionInteropInteropNodesFactory;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInteropInteropNodes;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;

@Collect(getter="getInstance", value={InteropNodes.class})
public final class ForeignExceptionInteropInteropNodes
extends InteropNodes {
    private static final Factory factory = new Factory(InteropMessageFactories.dispatchToId(ForeignExceptionInterop.class));
    private static final InteropNodes INSTANCE = new ForeignExceptionInteropInteropNodes();

    private ForeignExceptionInteropInteropNodes() {
        super(ForeignExceptionInterop.class, ThrowableInteropInteropNodes.getInstance());
    }

    public static InteropNodes getInstance() {
        return INSTANCE;
    }

    @Override
    protected void registerMessages(Class<?> cls) {
        InteropMessageFactories.register(cls, InteropMessage.Message.GetExceptionType, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasExceptionCause, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetExceptionCause, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasExceptionMessage, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetExceptionMessage, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasExceptionStackTrace, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetExceptionStackTrace, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.ThrowException, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsExceptionIncompleteSource, factory, true);
    }

    static final class Factory
    implements InteropMessageFactory {
        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return this.sourceDispatch;
        }

        @Override
        public final InteropMessage create(InteropMessage.Message message) {
            switch (message) {
                case GetExceptionType: {
                    return ForeignExceptionInteropInteropNodesFactory.GetExceptionTypeNodeGen.create();
                }
                case HasExceptionCause: {
                    return ForeignExceptionInteropInteropNodesFactory.HasExceptionCauseNodeGen.create();
                }
                case GetExceptionCause: {
                    return ForeignExceptionInteropInteropNodesFactory.GetExceptionCauseNodeGen.create();
                }
                case HasExceptionMessage: {
                    return ForeignExceptionInteropInteropNodesFactory.HasExceptionMessageNodeGen.create();
                }
                case GetExceptionMessage: {
                    return ForeignExceptionInteropInteropNodesFactory.GetExceptionMessageNodeGen.create();
                }
                case HasExceptionStackTrace: {
                    return ForeignExceptionInteropInteropNodesFactory.HasExceptionStackTraceNodeGen.create();
                }
                case GetExceptionStackTrace: {
                    return ForeignExceptionInteropInteropNodesFactory.GetExceptionStackTraceNodeGen.create();
                }
                case ThrowException: {
                    return ForeignExceptionInteropInteropNodesFactory.ThrowExceptionNodeGen.create();
                }
                case IsExceptionIncompleteSource: {
                    return ForeignExceptionInteropInteropNodesFactory.IsExceptionIncompleteSourceNodeGen.create();
                }
            }
            return null;
        }
    }

    static abstract class IsExceptionIncompleteSourceNode
    extends InteropMessage.IsExceptionIncompleteSource {
        IsExceptionIncompleteSourceNode() {
        }

        @Specialization
        static boolean isExceptionIncompleteSource(StaticObject object) throws UnsupportedMessageException {
            return ForeignExceptionInterop.isExceptionIncompleteSource(object);
        }
    }

    static abstract class ThrowExceptionNode
    extends InteropMessage.ThrowException {
        ThrowExceptionNode() {
        }

        @Specialization
        static RuntimeException throwException(StaticObject object) {
            return ForeignExceptionInterop.throwException(object);
        }
    }

    static abstract class GetExceptionStackTraceNode
    extends InteropMessage.GetExceptionStackTrace {
        GetExceptionStackTraceNode() {
        }

        @Specialization
        static Object getExceptionStackTrace(StaticObject object) throws UnsupportedMessageException {
            return ForeignExceptionInterop.getExceptionStackTrace(object);
        }
    }

    static abstract class HasExceptionStackTraceNode
    extends InteropMessage.HasExceptionStackTrace {
        HasExceptionStackTraceNode() {
        }

        @Specialization
        static boolean hasExceptionStackTrace(StaticObject object) {
            return ForeignExceptionInterop.hasExceptionStackTrace(object);
        }
    }

    static abstract class GetExceptionMessageNode
    extends InteropMessage.GetExceptionMessage {
        GetExceptionMessageNode() {
        }

        @Specialization
        static Object getExceptionMessage(StaticObject object) throws UnsupportedMessageException {
            return ForeignExceptionInterop.getExceptionMessage(object);
        }
    }

    static abstract class HasExceptionMessageNode
    extends InteropMessage.HasExceptionMessage {
        HasExceptionMessageNode() {
        }

        @Specialization
        static boolean hasExceptionMessage(StaticObject object) {
            return ForeignExceptionInterop.hasExceptionMessage(object);
        }
    }

    static abstract class GetExceptionCauseNode
    extends InteropMessage.GetExceptionCause {
        GetExceptionCauseNode() {
        }

        @Specialization
        static Object getExceptionCause(StaticObject object) throws UnsupportedMessageException {
            return ForeignExceptionInterop.getExceptionCause(object);
        }
    }

    static abstract class HasExceptionCauseNode
    extends InteropMessage.HasExceptionCause {
        HasExceptionCauseNode() {
        }

        @Specialization
        static boolean hasExceptionCause(StaticObject object) {
            return ForeignExceptionInterop.hasExceptionCause(object);
        }
    }

    static abstract class GetExceptionTypeNode
    extends InteropMessage.GetExceptionType {
        GetExceptionTypeNode() {
        }

        @Specialization
        static ExceptionType getExceptionType(StaticObject object) throws UnsupportedMessageException {
            return ForeignExceptionInterop.getExceptionType(object);
        }
    }
}

