/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class StringTable {
    private final EspressoContext context;
    private final ConcurrentHashMap<Symbol<?>, String> cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, StaticObject> interned = new ConcurrentHashMap();

    public StringTable(EspressoContext context) {
        this.context = context;
    }

    public StaticObject intern(Symbol<?> value) {
        return this.interned.computeIfAbsent(this.cache.computeIfAbsent(value, new Function<Symbol<?>, String>(){

            @Override
            public String apply(Symbol<?> value1) {
                return StringTable.createStringFromSymbol(value1);
            }
        }), new Function<String, StaticObject>(){

            @Override
            public StaticObject apply(String value1) {
                return StringTable.this.createStringObjectFromString(value1);
            }
        });
    }

    private StaticObject createStringObjectFromString(String value) {
        return this.context.getMeta().toGuestString(value);
    }

    private static String createStringFromSymbol(Symbol<?> value) {
        return value.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public @JavaType(value=String.class) StaticObject intern(final @JavaType(value=String.class) StaticObject guestString) {
        assert (StaticObject.notNull(guestString));
        String hostString = this.context.getMeta().toHostString(guestString);
        return this.interned.computeIfAbsent(hostString, new Function<String, StaticObject>(){
            final /* synthetic */ StringTable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public StaticObject apply(String k) {
                return guestString;
            }
        });
    }
}

