/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

public final class JavaVersion
implements Comparable<JavaVersion> {
    public static final JavaVersion HOST_VERSION = JavaVersion.forVersion(System.getProperty("java.version"));
    public static final int LATEST_SUPPORTED = 21;
    private final int version;

    JavaVersion(int version) {
        this.version = version;
    }

    public static JavaVersion forVersion(int version) {
        if (version < 1) {
            throw new IllegalArgumentException("Unsupported java version: " + version);
        }
        return new JavaVersion(version);
    }

    public static JavaVersion forVersion(String version) {
        int firstDot;
        int begin = 0;
        int end = version.length();
        if (version.startsWith("1.")) {
            begin = 2;
        }
        if ((firstDot = version.indexOf(46, begin)) >= 0) {
            end = firstDot;
        }
        String normalizedVersion = version.substring(begin, end);
        try {
            int intVersion = Integer.parseInt(normalizedVersion);
            return JavaVersion.forVersion(intVersion);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unsupported java version: " + version + " (" + normalizedVersion + ")");
        }
    }

    public static JavaVersion latestSupported() {
        return JavaVersion.forVersion(21);
    }

    public boolean java8OrEarlier() {
        return this.version <= 8;
    }

    public boolean java9OrLater() {
        return this.version >= 9;
    }

    public boolean java10OrLater() {
        return this.version >= 10;
    }

    public boolean java11OrLater() {
        return this.version >= 11;
    }

    public boolean java11OrEarlier() {
        return this.version <= 11;
    }

    public boolean java13OrEarlier() {
        return this.version <= 13;
    }

    public boolean java15OrLater() {
        return this.version >= 15;
    }

    public boolean java16OrLater() {
        return this.version >= 16;
    }

    public boolean java17OrEarlier() {
        return this.version <= 17;
    }

    public boolean java17OrLater() {
        return this.version >= 17;
    }

    public boolean java18OrEarlier() {
        return this.version <= 18;
    }

    public boolean java19OrLater() {
        return this.version >= 19;
    }

    public boolean java20OrLater() {
        return this.version >= 20;
    }

    public boolean java20OrEarlier() {
        return this.version <= 20;
    }

    public boolean java21OrLater() {
        return this.version >= 21;
    }

    public boolean inRange(int low, int high) {
        return this.version >= low && this.version <= high;
    }

    public boolean modulesEnabled() {
        return this.java9OrLater();
    }

    public boolean varHandlesEnabled() {
        return this.java9OrLater();
    }

    public boolean compactStringsEnabled() {
        return this.java9OrLater();
    }

    public int classFileVersion() {
        return this.version + 44;
    }

    @Override
    public int compareTo(JavaVersion o) {
        return Integer.compare(this.version, o.version);
    }

    public String toString() {
        return Integer.toString(this.version);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaVersion)) {
            return false;
        }
        return this.version == ((JavaVersion)obj).version;
    }

    public int hashCode() {
        return this.version;
    }

    public static final class VersionRange {
        public static final VersionRange VERSION_8_OR_LOWER = VersionRange.lower(8);
        public static final VersionRange VERSION_9_OR_HIGHER = VersionRange.higher(9);
        public static final VersionRange VERSION_16_OR_HIGHER = VersionRange.higher(16);
        public static final VersionRange VERSION_17_OR_HIGHER = VersionRange.higher(17);
        public static final VersionRange VERSION_19_OR_HIGHER = VersionRange.higher(19);
        public static final VersionRange ALL = new VersionRange(0, 21);
        private final int low;
        private final int high;

        public VersionRange(int low, int high) {
            this.low = low;
            this.high = high;
        }

        public static VersionRange lower(int version) {
            return new VersionRange(0, version);
        }

        public static VersionRange higher(int version) {
            return new VersionRange(version, 21);
        }

        public boolean contains(JavaVersion version) {
            return version.inRange(this.low, this.high);
        }
    }
}

