/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.PackageTable;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.JImageHelper;
import com.oracle.truffle.espresso.runtime.jimage.BasicImageReader;
import com.oracle.truffle.espresso.runtime.jimage.ImageLocation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class JavaJImageHelper
implements JImageHelper {
    private static final ByteSequence PACKAGES_PREFIX = ByteSequence.wrap("/packages/".getBytes(StandardCharsets.UTF_8));
    private static final ByteSequence JAVA_BASE = ByteSequence.wrap("java.base".getBytes(StandardCharsets.UTF_8));
    private final EspressoContext context;
    private final BasicImageReader reader;

    public JavaJImageHelper(BasicImageReader reader, EspressoContext context) {
        this.reader = reader;
        this.context = context;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] getClassBytes(ByteSequence name) {
        ImageLocation location = this.findLocation(name);
        if (location == null) {
            return null;
        }
        return this.reader.getResource(location);
    }

    private ImageLocation findLocation(ByteSequence name) {
        ImageLocation location = this.reader.findLocation(name);
        if (location != null) {
            return location;
        }
        ByteSequence pkg = JavaJImageHelper.packageFromName(name);
        if (pkg == null) {
            return null;
        }
        if (!this.context.modulesInitialized()) {
            location = this.reader.findLocation(JAVA_BASE, name);
            if (location != null || !this.context.metaInitialized()) {
                return location;
            }
            ByteBuffer module = this.packageToModule(pkg);
            if (module == null) {
                return null;
            }
            return this.reader.findLocation(ByteSequence.from(module), name);
        }
        Symbol<Symbol.Name> pkgSymbol = this.context.getNames().lookup(pkg);
        if (pkgSymbol == null) {
            return null;
        }
        PackageTable.PackageEntry pkgEntry = (PackageTable.PackageEntry)this.context.getRegistries().getBootClassRegistry().packages().lookup(pkgSymbol);
        if (pkgEntry == null) {
            return null;
        }
        Symbol<Symbol.Name> moduleName = pkgEntry.module().getName();
        Symbol<Symbol.Name> moduleNameAsString = moduleName == null ? ByteSequence.EMPTY : moduleName;
        return this.reader.findLocation(moduleNameAsString, name);
    }

    private ByteBuffer packageToModule(ByteSequence pkg) {
        ImageLocation location = this.reader.findLocation(PACKAGES_PREFIX.concat(pkg));
        if (location == null) {
            return null;
        }
        ByteBuffer buffer = this.reader.getResourceBuffer(location);
        int offset = 0;
        while (buffer.remaining() >= 8) {
            boolean isEmpty;
            boolean bl = isEmpty = buffer.getInt() != 0;
            if (!isEmpty) {
                offset = buffer.getInt();
                break;
            }
            buffer.position(buffer.position() + 4);
        }
        return this.reader.getRawString(offset);
    }

    private static ByteSequence packageFromName(ByteSequence name) {
        int lastSlash = name.lastIndexOf((byte)47);
        if (lastSlash == -1) {
            return null;
        }
        return name.subSequence(0, lastSlash);
    }
}

