/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.VM;

public class InteropUtils {
    public static boolean isNegativeZero(float f) {
        return Float.floatToRawIntBits(f) == Float.floatToRawIntBits(-0.0f);
    }

    public static boolean isNegativeZero(double d) {
        return Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(-0.0);
    }

    public static boolean isAtMostByte(Klass klass) {
        return klass == klass.getMeta().java_lang_Byte;
    }

    public static boolean isAtMostShort(Klass klass) {
        Meta meta = klass.getMeta();
        return klass == meta.java_lang_Byte || klass == meta.java_lang_Short;
    }

    public static boolean isAtMostInt(Klass klass) {
        Meta meta = klass.getMeta();
        return klass == meta.java_lang_Byte || klass == meta.java_lang_Short || klass == meta.java_lang_Integer;
    }

    public static boolean isAtMostLong(Klass klass) {
        Meta meta = klass.getMeta();
        return klass == meta.java_lang_Byte || klass == meta.java_lang_Short || klass == meta.java_lang_Integer || klass == meta.java_lang_Long;
    }

    public static boolean isAtMostFloat(Klass klass) {
        Meta meta = klass.getMeta();
        return klass == meta.java_lang_Byte || klass == meta.java_lang_Short || klass == meta.java_lang_Float;
    }

    public static Object unwrap(EspressoLanguage language, StaticObject object, Meta meta) {
        if (meta.isBoxed(object.getKlass())) {
            return meta.unboxGuest(object);
        }
        if (object.isForeignObject()) {
            return object.rawForeignObject(language);
        }
        if (meta.polyglot == null || StaticObject.isNull(object)) {
            return object;
        }
        if (meta.java_lang_Throwable.isAssignableFrom(object.getKlass())) {
            return InteropUtils.unwrapForeignException(object, meta);
        }
        return object;
    }

    private static Object unwrapForeignException(StaticObject object, Meta meta) {
        assert (meta.java_lang_Throwable.isAssignableFrom(object.getKlass()));
        if (meta.HIDDEN_FRAMES.getHiddenObject(object) == VM.StackTrace.FOREIGN_MARKER_STACK_TRACE) {
            return meta.java_lang_Throwable_backtrace.getObject(object).rawForeignObject(meta.getLanguage());
        }
        return object;
    }

    public static Object unwrap(EspressoLanguage language, Object object, Meta meta) {
        if (object instanceof StaticObject) {
            return InteropUtils.unwrap(language, (StaticObject)object, meta);
        }
        return object;
    }

    public static boolean isForeignException(EspressoException e) {
        assert (e != null);
        StaticObject guestException = e.getGuestException();
        Meta meta = guestException.getKlass().getMeta();
        if (meta.polyglot == null) {
            return false;
        }
        if (guestException.getKlass() == meta.polyglot.ForeignException) {
            return true;
        }
        Object stack = meta.HIDDEN_FRAMES.getHiddenObject(guestException);
        return stack == VM.StackTrace.FOREIGN_MARKER_STACK_TRACE;
    }

    @CompilerDirectives.TruffleBoundary
    public static RuntimeException unwrapExceptionBoundary(EspressoLanguage language, EspressoException exception, Meta meta) {
        if (InteropUtils.isForeignException(exception)) {
            StaticObject guestException = exception.getGuestException();
            return (AbstractTruffleException)((Object)meta.java_lang_Throwable_backtrace.getObject(guestException).rawForeignObject(language));
        }
        return exception;
    }
}

