/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.LanguageAccess;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.vm.VM;
import java.util.Arrays;

public final class GuestAllocator
implements LanguageAccess {
    private final EspressoLanguage language;
    private final AllocationReporter allocationReporter;

    public GuestAllocator(EspressoLanguage language, AllocationReporter allocationReporter) {
        this.language = language;
        this.allocationReporter = allocationReporter;
        if (allocationReporter != null) {
            if (allocationReporter.isActive()) {
                this.getLanguage().invalidateAllocationTrackingDisabled();
            }
            allocationReporter.addActiveListener(isActive -> {
                if (isActive.booleanValue()) {
                    this.getLanguage().invalidateAllocationTrackingDisabled();
                }
            });
        }
    }

    @Override
    public EspressoLanguage getLanguage() {
        return this.language;
    }

    public StaticObject createNew(ObjectKlass klass) {
        assert (AllocationChecks.canAllocateNewReference(klass));
        klass.safeInitialize();
        StaticObject newObj = ((StaticObject.StaticObjectFactory)klass.getLinkedKlass().getShape(false).getFactory()).create(klass);
        GuestAllocator.initInstanceFields(newObj, klass);
        return this.trackAllocation(klass, newObj);
    }

    public StaticObject copy(StaticObject toCopy) {
        StaticObject obj;
        if (StaticObject.isNull(toCopy)) {
            return toCopy;
        }
        toCopy.checkNotForeign();
        if (toCopy.getKlass().isArray()) {
            obj = this.wrapArrayAs((ArrayKlass)toCopy.getKlass(), toCopy.cloneWrappedArray(this.getLanguage()));
        } else {
            try {
                obj = (StaticObject)toCopy.clone();
            }
            catch (CloneNotSupportedException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }
        return this.trackAllocation(obj.getKlass(), obj);
    }

    public StaticObject createClass(Klass klass) {
        assert (klass != null);
        CompilerAsserts.neverPartOfCompilation();
        ObjectKlass guestClass = klass.getMeta().java_lang_Class;
        StaticObject newObj = ((StaticObject.StaticObjectFactory)guestClass.getLinkedKlass().getShape(false).getFactory()).create(guestClass);
        GuestAllocator.initInstanceFields(newObj, guestClass);
        klass.getMeta().java_lang_Class_classLoader.setObject(newObj, klass.getDefiningClassLoader());
        if (klass.getContext().getJavaVersion().modulesEnabled()) {
            GuestAllocator.setModule(newObj, klass);
        }
        if (klass.isArray() && klass.getMeta().java_lang_Class_componentType != null) {
            klass.getMeta().java_lang_Class_componentType.setObject(newObj, ((ArrayKlass)klass).getComponentType().initializeEspressoClass());
        }
        klass.getMeta().HIDDEN_PROTECTION_DOMAIN.setHiddenObject(newObj, StaticObject.NULL);
        klass.getMeta().HIDDEN_MIRROR_KLASS.setHiddenObject(newObj, klass);
        return this.trackAllocation(klass, newObj);
    }

    public StaticObject createStatics(ObjectKlass klass) {
        assert (klass != null);
        CompilerAsserts.neverPartOfCompilation();
        StaticObject newObj = ((StaticObject.StaticObjectFactory)klass.getLinkedKlass().getShape(true).getFactory()).create(klass);
        GuestAllocator.initInitialStaticFields(newObj, klass);
        return this.trackAllocation(klass, newObj);
    }

    public StaticObject createNewPrimitiveArray(Klass klass, int length) {
        assert (klass.isPrimitive());
        return this.createNewPrimitiveArray(klass.getMeta(), klass.getJavaKind(), length);
    }

    public StaticObject createNewPrimitiveArray(Meta meta, JavaKind kind, int length) {
        assert (kind.isPrimitive());
        return this.createNewPrimitiveArray(meta, (byte)kind.getBasicType(), length);
    }

    public StaticObject createNewPrimitiveArray(Meta meta, byte jvmPrimitiveType, int length) {
        assert (AllocationChecks.canAllocateNewArray(length));
        switch (jvmPrimitiveType) {
            case 4: {
                return this.wrapArrayAs(meta._boolean_array, new byte[length]);
            }
            case 5: {
                return StaticObject.wrap(new char[length], meta);
            }
            case 6: {
                return StaticObject.wrap(new float[length], meta);
            }
            case 7: {
                return StaticObject.wrap(new double[length], meta);
            }
            case 8: {
                return StaticObject.wrap(new byte[length], meta);
            }
            case 9: {
                return StaticObject.wrap(new short[length], meta);
            }
            case 10: {
                return StaticObject.wrap(new int[length], meta);
            }
            case 11: {
                return StaticObject.wrap(new long[length], meta);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    public StaticObject createNewReferenceArray(Klass componentKlass, int length) {
        assert (length >= 0);
        assert (!componentKlass.isPrimitive());
        assert (AllocationChecks.canAllocateNewArray(length));
        Object[] arr = new StaticObject[length];
        Arrays.fill(arr, StaticObject.NULL);
        return this.wrapArrayAs(componentKlass.getArrayClass(), arr);
    }

    public StaticObject createNewMultiArray(Klass component, int[] dimensions) {
        assert (dimensions != null && dimensions.length > 0);
        assert (AllocationChecks.canAllocateMultiArray(component.getMeta(), component, dimensions));
        return this.createNewMultiArray(component, dimensions, 0);
    }

    public StaticObject wrapArrayAs(ArrayKlass klass, Object array) {
        assert (klass != null);
        assert (array != null);
        assert (!(array instanceof StaticObject));
        assert (array.getClass().isArray());
        assert (klass.getComponentType().isPrimitive() || array instanceof StaticObject[]);
        StaticObject newObj = ((StaticObject.StaticObjectFactory)this.getLanguage().getArrayShape().getFactory()).create(klass);
        this.getLanguage().getArrayProperty().setObject((Object)newObj, array);
        return this.trackAllocation(klass, newObj);
    }

    public @JavaType(internalName="Lcom/oracle/truffle/espresso/polyglot/ForeignException;") StaticObject createForeignException(EspressoContext context, Object foreignObject, InteropLibrary interopLibrary) {
        assert (context.getEspressoEnv().Polyglot);
        Meta meta = context.getMeta();
        assert (meta.polyglot != null);
        assert (interopLibrary.isException(foreignObject));
        assert (!(foreignObject instanceof StaticObject));
        StaticObject foreignException = this.createNew(meta.polyglot.ForeignException);
        meta.HIDDEN_FRAMES.setHiddenObject(foreignException, VM.StackTrace.FOREIGN_MARKER_STACK_TRACE);
        StaticObject foreignWrapper = GuestAllocator.createForeign(this.getLanguage(), meta.java_lang_Object, foreignObject, interopLibrary);
        meta.java_lang_Throwable_backtrace.setObject(foreignException, foreignWrapper);
        if (meta.getJavaVersion().java9OrLater()) {
            try {
                Object exceptionStackTrace;
                InteropLibrary uncached;
                if (interopLibrary.hasExceptionStackTrace(foreignObject) && (uncached = InteropLibrary.getUncached((Object)(exceptionStackTrace = interopLibrary.getExceptionStackTrace(foreignObject)))).hasArrayElements(exceptionStackTrace)) {
                    int depth = (int)uncached.getArraySize(exceptionStackTrace);
                    meta.java_lang_Throwable_depth.setInt(foreignException, depth);
                }
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }
        return foreignException;
    }

    public static StaticObject createForeign(EspressoLanguage lang, Klass klass, Object foreignObject, InteropLibrary interopLibrary) {
        if (interopLibrary.isNull(foreignObject)) {
            return GuestAllocator.createForeignNull(lang, foreignObject);
        }
        return GuestAllocator.createForeign(lang, klass, foreignObject);
    }

    public static StaticObject createForeignNull(EspressoLanguage lang, Object foreignObject) {
        assert (InteropLibrary.getUncached().isNull(foreignObject));
        return GuestAllocator.createForeign(lang, null, foreignObject);
    }

    private static void initInstanceFields(StaticObject obj, ObjectKlass thisKlass) {
        obj.checkNotForeign();
        if (CompilerDirectives.isPartialEvaluationConstant((Object)thisKlass)) {
            GuestAllocator.initLoop(obj, thisKlass);
        } else {
            GuestAllocator.initLoopNoExplode(obj, thisKlass);
        }
    }

    @ExplodeLoop
    private static void initLoop(StaticObject obj, ObjectKlass thisKlass) {
        for (Field f : thisKlass.getFieldTable()) {
            assert (!f.isStatic());
            if (f.isHidden() || f.isRemoved() || f.getKind() != JavaKind.Object) continue;
            f.setObject(obj, StaticObject.NULL);
        }
    }

    private static void initLoopNoExplode(StaticObject obj, ObjectKlass thisKlass) {
        for (Field f : thisKlass.getFieldTable()) {
            assert (!f.isStatic());
            if (f.isHidden() || f.isRemoved() || f.getKind() != JavaKind.Object) continue;
            f.setObject(obj, StaticObject.NULL);
        }
    }

    private static void initInitialStaticFields(StaticObject obj, ObjectKlass thisKlass) {
        obj.checkNotForeign();
        if (CompilerDirectives.isPartialEvaluationConstant((Object)thisKlass)) {
            GuestAllocator.staticInitLoop(obj, thisKlass);
        } else {
            GuestAllocator.staticInitLoopNoExplode(obj, thisKlass);
        }
    }

    @ExplodeLoop
    private static void staticInitLoop(StaticObject obj, ObjectKlass thisKlass) {
        for (Field f : thisKlass.getInitialStaticFields()) {
            assert (f.isStatic());
            if (f.getKind() != JavaKind.Object || f.isRemoved()) continue;
            if (f.isHidden()) {
                f.setHiddenObject(obj, StaticObject.NULL);
                continue;
            }
            f.setObject(obj, StaticObject.NULL);
        }
    }

    private static void staticInitLoopNoExplode(StaticObject obj, ObjectKlass thisKlass) {
        for (Field f : thisKlass.getInitialStaticFields()) {
            assert (f.isStatic());
            if (f.getKind() != JavaKind.Object || f.isRemoved()) continue;
            if (f.isHidden()) {
                f.setHiddenObject(obj, StaticObject.NULL);
                continue;
            }
            f.setObject(obj, StaticObject.NULL);
        }
    }

    private static StaticObject createForeign(EspressoLanguage lang, Klass klass, Object foreignObject) {
        assert (foreignObject != null);
        assert (klass == null || !klass.isAbstract() || klass.isArray());
        StaticObject newObj = ((StaticObject.StaticObjectFactory)lang.getForeignShape().getFactory()).create(klass, true);
        lang.getForeignProperty().setObject((Object)newObj, foreignObject);
        if (klass != null) {
            klass.safeInitialize();
        }
        return GuestAllocator.trackAllocation(klass, newObj, lang, klass);
    }

    private static void setModule(StaticObject obj, Klass klass) {
        StaticObject module = klass.module().module();
        if (StaticObject.isNull(module)) {
            if (klass.getContext().getRegistries().javaBaseDefined()) {
                klass.getContext().getMeta().java_lang_Class_module.setObject(obj, klass.getRegistries().getJavaBaseModule().module());
            } else {
                klass.getContext().getRegistries().addToFixupList(klass);
            }
        } else {
            klass.getContext().getMeta().java_lang_Class_module.setObject(obj, module);
        }
    }

    private StaticObject createNewMultiArray(Klass component, int[] dimensions, int currentDimension) {
        assert (dimensions != null && dimensions.length > 0);
        int dimLength = dimensions[currentDimension];
        if (currentDimension == dimensions.length - 1) {
            if (component.isPrimitive()) {
                return this.createNewPrimitiveArray(component, dimLength);
            }
            return this.createNewReferenceArray(component, dimLength);
        }
        StaticObject[] wrapped = new StaticObject[dimLength];
        assert (component instanceof ArrayKlass);
        Klass downComponent = ((ArrayKlass)component).getComponentType();
        if (CompilerDirectives.isPartialEvaluationConstant((Object)dimLength)) {
            this.initMultiArrayLoop(downComponent, wrapped, dimLength, dimensions, currentDimension);
        } else {
            this.initMultiArrayLoopNoExplode(downComponent, wrapped, dimLength, dimensions, currentDimension);
        }
        return this.wrapArrayAs(component.array(), wrapped);
    }

    @ExplodeLoop
    private void initMultiArrayLoop(Klass klass, StaticObject[] wrapped, int dimLength, int[] dimensions, int pos) {
        for (int i = 0; i < dimLength; ++i) {
            wrapped[i] = this.createNewMultiArray(klass, dimensions, pos + 1);
        }
    }

    private void initMultiArrayLoopNoExplode(Klass downComponent, StaticObject[] wrapped, int dimLength, int[] dimensions, int pos) {
        for (int i = 0; i < dimLength; ++i) {
            wrapped[i] = this.createNewMultiArray(downComponent, dimensions, pos + 1);
        }
    }

    private StaticObject trackAllocation(Klass klass, StaticObject obj) {
        return GuestAllocator.trackAllocation(klass, obj, this.getLanguage(), klass);
    }

    private static StaticObject trackAllocation(Klass klass, StaticObject obj, EspressoLanguage lang, ContextAccessImpl contextAccess) {
        if (klass == null || lang.isAllocationTrackingDisabled()) {
            return obj;
        }
        if (!CompilerDirectives.isPartialEvaluationConstant((Object)contextAccess)) {
            return GuestAllocator.trackAllocationBoundary(contextAccess, obj);
        }
        return contextAccess.getAllocator().trackAllocation(obj);
    }

    @CompilerDirectives.TruffleBoundary
    private static StaticObject trackAllocationBoundary(ContextAccessImpl context, StaticObject obj) {
        return context.getAllocator().trackAllocation(obj);
    }

    public <T> T trackAllocation(T object) {
        if (this.allocationReporter != null) {
            CompilerAsserts.partialEvaluationConstant((Object)this.allocationReporter);
            this.allocationReporter.onEnter(null, 0L, Long.MIN_VALUE);
            this.allocationReporter.onReturnValue(object, 0L, Long.MIN_VALUE);
        }
        return object;
    }

    public static final class AllocationChecks {
        private AllocationChecks() {
        }

        public static void checkCanAllocateNewReference(Meta meta, Klass klass, boolean error) {
            AllocationChecks.checkCanAllocateNewReference(meta, klass, error, AllocationProfiler.NO_PROFILE);
        }

        public static void checkCanAllocateArray(Meta meta, int size) {
            AllocationChecks.checkCanAllocateArray(meta, size, AllocationProfiler.NO_PROFILE);
        }

        public static void checkCanAllocateMultiArray(Meta meta, Klass component, int[] dimensions) {
            AllocationChecks.checkCanAllocateMultiArray(meta, component, dimensions, AllocationProfiler.NO_PROFILE);
        }

        public static void checkCanAllocateNewReference(Meta meta, Klass klass, boolean error, AllocationProfiler profile) {
            if (!AllocationChecks.canAllocateNewReference(klass)) {
                profile.enterNewReference();
                throw meta.throwException(error ? meta.java_lang_InstantiationError : meta.java_lang_InstantiationException);
            }
        }

        public static void checkCanAllocateArray(Meta meta, int size, AllocationProfiler profile) {
            if (!AllocationChecks.canAllocateNewArray(size)) {
                profile.enterNewArray();
                throw meta.throwException(meta.java_lang_NegativeArraySizeException);
            }
        }

        public static void checkCanAllocateMultiArray(Meta meta, Klass component, int[] dimensions, AllocationProfiler profile) {
            if (AllocationChecks.invalidComponent(meta, component)) {
                profile.enterNewMultiArray();
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            if (AllocationChecks.invalidDimensionsArray(dimensions)) {
                profile.enterNewMultiArray();
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            if (AllocationChecks.invalidDimensions(dimensions)) {
                profile.enterNewMultiArray();
                throw meta.throwException(meta.java_lang_NegativeArraySizeException);
            }
        }

        private static boolean canAllocateNewReference(Klass klass) {
            return klass instanceof ObjectKlass && !klass.isAbstract() && !klass.isInterface();
        }

        private static boolean canAllocateNewArray(int size) {
            return size >= 0;
        }

        private static boolean canAllocateMultiArray(Meta meta, Klass component, int[] dimensions) {
            if (AllocationChecks.invalidComponent(meta, component)) {
                return false;
            }
            if (AllocationChecks.invalidDimensionsArray(dimensions)) {
                return false;
            }
            return !AllocationChecks.invalidDimensions(dimensions);
        }

        private static boolean invalidDimensionsArray(int[] dimensions) {
            return dimensions.length == 0 || dimensions.length > 255;
        }

        @ExplodeLoop
        private static boolean invalidDimensions(int[] dimensions) {
            if (CompilerDirectives.isPartialEvaluationConstant((Object)dimensions)) {
                return AllocationChecks.invalidDimensionsExplode(dimensions);
            }
            return AllocationChecks.invalidDimensionsNoExplode(dimensions);
        }

        private static boolean invalidDimensionsNoExplode(int[] dimensions) {
            for (int dim : dimensions) {
                if (AllocationChecks.canAllocateNewArray(dim)) continue;
                return true;
            }
            return false;
        }

        @ExplodeLoop
        private static boolean invalidDimensionsExplode(int[] dimensions) {
            for (int dim : dimensions) {
                if (AllocationChecks.canAllocateNewArray(dim)) continue;
                return true;
            }
            return false;
        }

        private static boolean invalidComponent(Meta meta, Klass component) {
            return component == meta._void;
        }
    }

    public static interface AllocationProfiler {
        public static final AllocationProfiler NO_PROFILE = new AllocationProfiler(){

            @Override
            public void enterNewReference() {
            }

            @Override
            public void enterNewArray() {
            }

            @Override
            public void enterNewMultiArray() {
            }
        };

        public void enterNewReference();

        public void enterNewArray();

        public void enterNewMultiArray();
    }
}

