/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.impl.Method;

@ExportLibrary(value=InteropLibrary.class)
public final class ForeignStackTraceElementObject
implements TruffleObject {
    private final Method method;
    private final SourceSection sourceSection;

    public ForeignStackTraceElementObject(Method method, SourceSection sourceSection) {
        this.method = method;
        this.sourceSection = sourceSection;
    }

    @ExportMessage
    boolean hasExecutableName() {
        return true;
    }

    @ExportMessage
    Object getExecutableName() {
        return this.method.getNameAsString();
    }

    @ExportMessage
    boolean hasSourceLocation() {
        return this.sourceSection != null;
    }

    @ExportMessage
    SourceSection getSourceLocation() throws UnsupportedMessageException {
        if (this.sourceSection == null) {
            throw UnsupportedMessageException.create();
        }
        return this.sourceSection;
    }

    @ExportMessage
    boolean hasDeclaringMetaObject() {
        return true;
    }

    @ExportMessage
    Object getDeclaringMetaObject() {
        return this.method.getDeclaringKlass().mirror();
    }
}

