/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.ref.EspressoReference;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoExitException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.substitutions.Target_java_lang_Thread;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.lang.ref.ReferenceQueue;

final class EspressoReferenceDrainer
extends ContextAccessImpl {
    private volatile Thread hostToGuestReferenceDrainThread;
    private volatile ReferenceDrain drain;
    private final ReferenceQueue<StaticObject> referenceQueue = new ReferenceQueue();
    private volatile StaticObject referencePendingList = StaticObject.NULL;
    @CompilerDirectives.CompilationFinal
    private volatile EspressoLock pendingLock;

    EspressoReferenceDrainer(EspressoContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EspressoLock getLock() {
        if (this.pendingLock == null) {
            EspressoReferenceDrainer espressoReferenceDrainer = this;
            synchronized (espressoReferenceDrainer) {
                if (this.pendingLock == null) {
                    this.pendingLock = EspressoLock.create(this.getContext().getBlockingSupport());
                }
            }
        }
        return this.pendingLock;
    }

    void initReferenceDrain() {
        TruffleLanguage.Env env = this.getContext().getEnv();
        final Meta meta = this.getMeta();
        if (this.getJavaVersion().java8OrEarlier()) {
            this.drain = new ReferenceDrain(this){
                final /* synthetic */ EspressoReferenceDrainer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void updateReferencePendingList(EspressoReference head, EspressoReference prev, StaticObject lock) {
                    StaticObject obj = meta.java_lang_ref_Reference_pending.getAndSetObject(meta.java_lang_ref_Reference.getStatics(), head.getGuestReference());
                    meta.java_lang_ref_Reference_discovered.set(prev.getGuestReference(), obj);
                    this.this$0.getVM().JVM_MonitorNotify(lock, this.profiler);
                }
            };
        } else if (this.getJavaVersion().java9OrLater()) {
            this.drain = new ReferenceDrain(this){
                final /* synthetic */ EspressoReferenceDrainer this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void updateReferencePendingList(EspressoReference head, EspressoReference prev, StaticObject lock) {
                    EspressoLock pLock = this.this$0.getLock();
                    pLock.lock();
                    try {
                        StaticObject obj = this.this$0.referencePendingList;
                        this.this$0.referencePendingList = head.getGuestReference();
                        meta.java_lang_ref_Reference_discovered.set(prev.getGuestReference(), obj);
                        this.this$0.getVM().JVM_MonitorNotify(lock, this.profiler);
                        pLock.signalAll();
                    }
                    finally {
                        pLock.unlock();
                    }
                }
            };
        } else {
            throw EspressoError.shouldNotReachHere();
        }
        if (this.getContext().multiThreadingEnabled()) {
            this.hostToGuestReferenceDrainThread = env.newTruffleThreadBuilder((Runnable)this.drain).build();
            this.hostToGuestReferenceDrainThread.setName("Reference Drain");
        }
    }

    void startReferenceDrain() {
        if (this.hostToGuestReferenceDrainThread != null) {
            this.hostToGuestReferenceDrainThread.setDaemon(true);
            this.hostToGuestReferenceDrainThread.start();
        }
    }

    void shutdownAndWaitReferenceDrain() {
        if (this.hostToGuestReferenceDrainThread != null) {
            while (this.hostToGuestReferenceDrainThread.isAlive()) {
                this.getContext().getEnv().submitThreadLocal(new Thread[]{this.hostToGuestReferenceDrainThread}, (ThreadLocalAction)new ExitTLA());
                this.hostToGuestReferenceDrainThread.interrupt();
                try {
                    this.hostToGuestReferenceDrainThread.join(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    Thread drainHostThread() {
        return this.hostToGuestReferenceDrainThread;
    }

    ReferenceQueue<StaticObject> getReferenceQueue() {
        return this.referenceQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StaticObject getAndClearReferencePendingList() {
        EspressoLock pLock = this.getLock();
        pLock.lock();
        try {
            StaticObject res = this.referencePendingList;
            this.referencePendingList = StaticObject.NULL;
            StaticObject staticObject = res;
            return staticObject;
        }
        finally {
            pLock.unlock();
        }
    }

    boolean hasReferencePendingList() {
        return !StaticObject.isNull(this.referencePendingList);
    }

    void waitForReferencePendingList() {
        if (this.hasReferencePendingList()) {
            return;
        }
        this.doWaitForReferencePendingList();
    }

    void triggerDrain() {
        Meta meta = this.getMeta();
        this.drain.drain(meta, EspressoReferenceDrainer.getGuestLock(meta), false);
    }

    @CompilerDirectives.TruffleBoundary
    private void doWaitForReferencePendingList() {
        try {
            EspressoLock pLock = this.getLock();
            pLock.lock();
            try {
                while (!this.hasReferencePendingList()) {
                    pLock.await(0L);
                }
            }
            finally {
                pLock.unlock();
            }
        }
        catch (GuestInterruptedException guestInterruptedException) {
            // empty catch block
        }
    }

    private void casNextIfNullAndMaybeClear(EspressoReference wrapper) {
        StaticObject ref = wrapper.getGuestReference();
        if (InterpreterToVM.instanceOf(ref, this.getMeta().sun_misc_Cleaner)) {
            wrapper.clear();
        }
        this.getMeta().java_lang_ref_Reference_next.compareAndSwapObject(ref, StaticObject.NULL, ref);
    }

    private static StaticObject getGuestLock(Meta meta) {
        return meta.java_lang_ref_Reference_lock.getObject(meta.java_lang_ref_Reference.tryInitializeAndGetStatics());
    }

    private abstract class ReferenceDrain
    implements Runnable {
        protected final SubstitutionProfiler profiler = new SubstitutionProfiler();

        private ReferenceDrain() {
        }

        private void safepoint() {
            TruffleSafepoint.poll((Node)this.profiler);
        }

        @Override
        public final void run() {
            Meta meta = EspressoReferenceDrainer.this.getMeta();
            try {
                EspressoReferenceDrainer.this.getVM().attachThread(Thread.currentThread());
                StaticObject lock = EspressoReferenceDrainer.getGuestLock(meta);
                while (true) {
                    this.drain(meta, lock, true);
                }
            }
            catch (Throwable throwable) {
                EspressoReferenceDrainer.this.getContext().getThreadAccess().terminate(EspressoReferenceDrainer.this.getContext().getCurrentPlatformThread());
                if (EspressoReferenceDrainer.this.getContext().isClosing()) {
                    return;
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void drain(Meta meta, StaticObject lock, boolean block) {
            EspressoReference head;
            do {
                this.safepoint();
                head = this.popQueue(block);
                if (head != null) continue;
                assert (!block);
                return;
            } while (StaticObject.notNull(meta.java_lang_ref_Reference_next.getObject(head.getGuestReference())));
            lock.getLock(EspressoReferenceDrainer.this.getContext()).lock();
            try {
                EspressoReference ref;
                assert (Target_java_lang_Thread.holdsLock(lock, meta)) : "must hold Reference.lock at the guest level";
                EspressoReferenceDrainer.this.casNextIfNullAndMaybeClear(head);
                EspressoReference prev = head;
                while ((ref = (EspressoReference)((Object)EspressoReferenceDrainer.this.referenceQueue.poll())) != null) {
                    if (StaticObject.notNull(meta.java_lang_ref_Reference_next.getObject(ref.getGuestReference()))) continue;
                    meta.java_lang_ref_Reference_discovered.set(prev.getGuestReference(), ref.getGuestReference());
                    EspressoReferenceDrainer.this.casNextIfNullAndMaybeClear(ref);
                    prev = ref;
                    this.safepoint();
                }
                meta.java_lang_ref_Reference_discovered.set(prev.getGuestReference(), prev.getGuestReference());
                this.updateReferencePendingList(head, prev, lock);
            }
            finally {
                lock.getLock(EspressoReferenceDrainer.this.getContext()).unlock();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private EspressoReference popQueue(boolean block) {
            if (block) {
                EspressoReference[] box = new EspressoReference[1];
                TruffleSafepoint.setBlockedThreadInterruptible((Node)this.profiler, queue -> {
                    box[0] = (EspressoReference)((Object)queue.remove());
                }, EspressoReferenceDrainer.this.referenceQueue);
                return box[0];
            }
            return (EspressoReference)((Object)EspressoReferenceDrainer.this.referenceQueue.poll());
        }

        protected abstract void updateReferencePendingList(EspressoReference var1, EspressoReference var2, StaticObject var3);
    }

    private static final class ExitTLA
    extends ThreadLocalAction {
        private ExitTLA() {
            super(true, false);
        }

        protected void perform(ThreadLocalAction.Access access) {
            throw new EspressoExitException(0);
        }
    }
}

