/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@ExportLibrary(value=InteropLibrary.class)
public final class EspressoFunction
implements TruffleObject {
    private final Method m;
    private final StaticObject receiver;

    private EspressoFunction(Method m, StaticObject receiver) {
        this.m = m;
        this.receiver = receiver;
    }

    public static EspressoFunction createStaticInvocable(Method m) {
        return new EspressoFunction(m, null);
    }

    public static EspressoFunction createInstanceInvocable(Method m, StaticObject receiver) {
        assert (receiver != null);
        return new EspressoFunction(m, receiver);
    }

    @ExportMessage
    public boolean isExecutable() {
        return true;
    }

    @ExportMessage
    public Object execute(Object[] args, @Cached InvokeEspressoNode invoke) throws ArityException, UnsupportedTypeException {
        return invoke.execute(this.m, this.receiver, args);
    }
}

