/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import com.oracle.truffle.espresso.vm.VM;

@ExportLibrary(value=InteropLibrary.class, delegateTo="exception")
public final class EspressoException
extends AbstractTruffleException {
    protected final StaticObject exception;

    private EspressoException(@JavaType(value=Throwable.class) StaticObject throwable) {
        assert (StaticObject.notNull(throwable));
        assert (InterpreterToVM.instanceOf(throwable, throwable.getKlass().getMeta().java_lang_Throwable));
        this.exception = throwable;
    }

    public static EspressoException wrap(@JavaType(value=Throwable.class) StaticObject throwable, Meta meta) {
        if (throwable.isForeignObject()) {
            return new EspressoException(throwable);
        }
        EspressoException wrapper = (EspressoException)((Object)meta.HIDDEN_EXCEPTION_WRAPPER.getHiddenObject(throwable));
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = new EspressoException(throwable);
        meta.HIDDEN_EXCEPTION_WRAPPER.setHiddenObject(throwable, (Object)wrapper);
        return wrapper;
    }

    public static VM.StackTrace getFrames(StaticObject exception, Meta meta) {
        return (VM.StackTrace)meta.HIDDEN_FRAMES.getHiddenObject(exception);
    }

    public String getMessage() {
        return EspressoException.getMessage(this.exception);
    }

    private static StaticObject getGuestMessage(StaticObject e) {
        return (StaticObject)e.getKlass().getMeta().java_lang_Throwable_detailMessage.get(e);
    }

    public static String getMessage(StaticObject e) {
        return Meta.toHostStringStatic(EspressoException.getGuestMessage(e));
    }

    public StaticObject getGuestMessage() {
        return EspressoException.getGuestMessage(this.getGuestException());
    }

    public StaticObject getGuestException() {
        return this.exception;
    }

    public String toString() {
        return "EspressoException<" + String.valueOf(this.getGuestException()) + ": " + this.getMessage() + ">";
    }

    private boolean match(String exceptionClass, String message) {
        if (exceptionClass == null) {
            return this.getMessage() != null && this.getMessage().contains(message);
        }
        if (this.getGuestException().getKlass().getType().toString().contains(exceptionClass)) {
            if (message == null) {
                return true;
            }
            if (this.getMessage() == null) {
                return false;
            }
            return this.getMessage().contains(message);
        }
        return false;
    }

    private boolean match(String exceptionClass) {
        return this.match(exceptionClass, null);
    }
}

