/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.runtime.Classpath;
import java.io.File;

public final class ClasspathFile {
    public final byte[] contents;
    public final Classpath.Entry classpathEntry;
    public final ByteSequence name;

    public ClasspathFile(byte[] contents, Classpath.Entry classpathEntry, ByteSequence name) {
        this.classpathEntry = classpathEntry;
        this.contents = contents;
        this.name = name;
    }

    public String toString() {
        if (this.classpathEntry.isArchive()) {
            return this.classpathEntry.file().getAbsolutePath() + "!" + String.valueOf(this.name);
        }
        return this.classpathEntry.file().getAbsolutePath() + File.separatorChar + String.valueOf(this.name);
    }

    public ClassFormatError classFormatError(String format, Object ... args) {
        throw new ClassFormatError(String.format(format, args) + " [in class file " + String.valueOf(this) + "]");
    }
}

