/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition.plugins.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.jdwp.api.RedefineInfo;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.redefinition.DefineKlassListener;
import com.oracle.truffle.espresso.redefinition.plugins.api.ClassLoadAction;
import com.oracle.truffle.espresso.redefinition.plugins.api.InternalRedefinitionPlugin;
import com.oracle.truffle.espresso.redefinition.plugins.impl.ExternalPluginHandler;
import com.oracle.truffle.espresso.redefinition.plugins.impl.RedefineListener;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public final class RedefinitionPluginHandler
implements RedefineListener,
DefineKlassListener {
    private final EspressoContext context;
    private final Set<InternalRedefinitionPlugin> internalPlugins = new HashSet<InternalRedefinitionPlugin>(1);
    private final Map<Symbol<Symbol.Type>, List<ClassLoadAction>> classLoadActions = new HashMap<Symbol<Symbol.Type>, List<ClassLoadAction>>();
    private ExternalPluginHandler externalPluginHandler;

    private RedefinitionPluginHandler(EspressoContext espressoContext) {
        this.context = espressoContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerClassLoadAction(String className, ClassLoadAction action) {
        Map<Symbol<Symbol.Type>, List<ClassLoadAction>> map = this.classLoadActions;
        synchronized (map) {
            Symbol<Symbol.Type> type = this.context.getTypes().fromClassGetName(className);
            List<ClassLoadAction> list = this.classLoadActions.get(type);
            if (list == null) {
                list = new ArrayList<ClassLoadAction>();
                this.classLoadActions.put(type, list);
            }
            list.add(action);
        }
    }

    public void registerExternalHotSwapHandler(StaticObject handler) {
        if (handler != null) {
            this.externalPluginHandler = ExternalPluginHandler.create(handler);
        }
    }

    public static RedefinitionPluginHandler create(EspressoContext espressoContext) {
        RedefinitionPluginHandler handler = new RedefinitionPluginHandler(espressoContext);
        ServiceLoader<InternalRedefinitionPlugin> serviceLoader = ServiceLoader.load(InternalRedefinitionPlugin.class);
        for (InternalRedefinitionPlugin plugin : serviceLoader) {
            handler.activatePlugin(plugin);
            espressoContext.registerRedefinitionPlugin(plugin);
        }
        espressoContext.getRegistries().registerListener(handler);
        return handler;
    }

    private void activatePlugin(InternalRedefinitionPlugin plugin) {
        this.internalPlugins.add(plugin);
        plugin.activate(this.context, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public void onKlassDefined(ObjectKlass klass) {
        Map<Symbol<Symbol.Type>, List<ClassLoadAction>> map = this.classLoadActions;
        synchronized (map) {
            Symbol<Symbol.Type> type = klass.getType();
            List<ClassLoadAction> loadActions = this.classLoadActions.get(type);
            if (loadActions != null) {
                for (ClassLoadAction loadAction : loadActions) {
                    loadAction.fire(klass);
                }
                this.classLoadActions.remove(type);
            }
        }
    }

    @Override
    public boolean shouldRerunClassInitializer(ObjectKlass klass, boolean changed, DebuggerController controller) {
        boolean rerun = false;
        for (InternalRedefinitionPlugin plugin : this.internalPlugins) {
            if (!plugin.shouldRerunClassInitializer(klass, changed)) continue;
            rerun = true;
            break;
        }
        if (this.externalPluginHandler != null) {
            rerun |= this.externalPluginHandler.shouldRerunClassInitializer(klass, changed, controller);
        }
        return rerun;
    }

    @Override
    public void postRedefinition(ObjectKlass[] changedKlasses, DebuggerController controller) {
        for (InternalRedefinitionPlugin plugin : this.internalPlugins) {
            try {
                plugin.postClassRedefinition(changedKlasses);
            }
            catch (Throwable throwable) {}
        }
        if (this.externalPluginHandler != null) {
            this.externalPluginHandler.postHotSwap(changedKlasses, controller);
        }
    }

    @Override
    public void collectExtraClassesToReload(List<RedefineInfo> redefineInfos, List<RedefineInfo> additional) {
        for (InternalRedefinitionPlugin plugin : this.internalPlugins) {
            plugin.collectExtraClassesToReload(redefineInfos, additional);
        }
    }
}

