/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke.inline.bodies;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.ConditionalInlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.GuardedConditionalInlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodPredicate;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.bodies.InlinedGetterNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.bodies.InlinedSetterNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.util.function.Supplier;

public abstract class InlinedFieldAccessNode
extends InlinedMethodNode.BodyNode
implements InlinedMethodPredicate {
    private static final byte INSTANCE_SETTER = 1;
    private static final byte STATIC_SETTER = 3;
    private static final byte INSTANCE_GETTER = 0;
    private static final byte STATIC_GETTER = 2;
    private static final int INSTANCE_SETTER_BCI = 2;
    private static final int STATIC_SETTER_BCI = 1;
    private static final int INSTANCE_GETTER_BCI = 1;
    private static final int STATIC_GETTER_BCI = 0;
    protected final Field field;

    protected InlinedFieldAccessNode(Method.MethodVersion method, char fieldCpi) {
        super(method);
        assert (InlinedFieldAccessNode.isResolutionSuccessAt(method, fieldCpi));
        this.field = InlinedFieldAccessNode.getInlinedField(method, fieldCpi);
    }

    public static InlinedMethodNode createGetter(Method inlinedMethod, int top, int opCode, int curBCI, int statementIndex) {
        Method.MethodVersion methodVersion = inlinedMethod.getMethodVersion();
        char fieldCpi = InlinedFieldAccessNode.getFieldCpi(false, methodVersion);
        FieldAccessRecipes recipes = new FieldAccessRecipes(() -> new InlinedGetterNode(methodVersion, fieldCpi));
        return InlinedFieldAccessNode.create(methodVersion, top, opCode, curBCI, statementIndex, recipes, fieldCpi);
    }

    public static InlinedMethodNode createSetter(Method inlinedMethod, int top, int opCode, int curBCI, int statementIndex) {
        Method.MethodVersion methodVersion = inlinedMethod.getMethodVersion();
        char fieldCpi = InlinedFieldAccessNode.getFieldCpi(true, methodVersion);
        FieldAccessRecipes recipes = new FieldAccessRecipes(() -> new InlinedSetterNode(methodVersion, fieldCpi));
        return InlinedFieldAccessNode.create(methodVersion, top, opCode, curBCI, statementIndex, recipes, fieldCpi);
    }

    private static InlinedMethodNode create(Method.MethodVersion inlinedMethod, int top, int opCode, int curBCI, int statementIndex, ConditionalInlinedMethodNode.Recipes recipes, char fieldCpi) {
        assert (InlinedMethodNode.isInlineCandidate(inlinedMethod.getMethod(), opCode));
        boolean isDefinitive = InlinedFieldAccessNode.isResolutionSuccessAt(inlinedMethod, fieldCpi);
        if (isDefinitive) {
            if (InlinedMethodNode.isUnconditionalInlineCandidate(opCode)) {
                return ConditionalInlinedMethodNode.getDefinitiveNode(recipes, inlinedMethod, top, opCode, curBCI, statementIndex);
            }
            return GuardedConditionalInlinedMethodNode.getDefinitiveNode(recipes, InlinedMethodPredicate.LEAF_ASSUMPTION_CHECK, inlinedMethod, top, opCode, curBCI, statementIndex);
        }
        InlinedMethodPredicate condition = (context, version, frame, node) -> InlinedFieldAccessNode.isResolutionSuccessAt(version, fieldCpi);
        if (InlinedMethodNode.isUnconditionalInlineCandidate(opCode)) {
            return new ConditionalInlinedMethodNode(inlinedMethod, top, opCode, curBCI, statementIndex, recipes, condition);
        }
        return new GuardedConditionalInlinedMethodNode(inlinedMethod, top, opCode, curBCI, statementIndex, recipes, condition, InlinedMethodPredicate.LEAF_ASSUMPTION_CHECK);
    }

    @Override
    public boolean isValid(EspressoContext context, Method.MethodVersion version, VirtualFrame frame, InlinedMethodNode node) {
        return !this.field.needsReResolution();
    }

    private static boolean isResolutionSuccessAt(Method.MethodVersion version, char fieldCpi) {
        return version.getPool().isResolutionSuccessAt(fieldCpi) && !InlinedFieldAccessNode.getInlinedField(version, fieldCpi).needsReResolution();
    }

    private static Field getInlinedField(Method.MethodVersion method, char fieldCpi) {
        assert (method.getPool().isResolutionSuccessAt(fieldCpi));
        return method.getPool().resolvedFieldAt(method.getDeclaringKlass(), fieldCpi);
    }

    private static char getFieldCpi(boolean isSetter, Method.MethodVersion method) {
        byte desc = 0;
        desc = (byte)(desc | (byte)(isSetter ? 1 : 0));
        desc = (byte)(desc | (byte)(method.isStatic() ? 2 : 0));
        int bci = switch (desc) {
            case 1 -> 2;
            case 3 -> 1;
            case 0 -> 1;
            case 2 -> 0;
            default -> throw EspressoError.shouldNotReachHere();
        };
        return new BytecodeStream(method.getOriginalCode()).readCPI(bci);
    }

    static final class FieldAccessRecipes
    implements ConditionalInlinedMethodNode.Recipes {
        private volatile InlinedFieldAccessNode body;
        private final Supplier<InlinedFieldAccessNode> supplier;

        FieldAccessRecipes(Supplier<InlinedFieldAccessNode> supplier) {
            this.supplier = supplier;
        }

        @Override
        public InlinedMethodNode.BodyNode cookBody() {
            return this.ensureInit();
        }

        @Override
        public InlinedMethodPredicate cookGuard() {
            return this.ensureInit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InlinedFieldAccessNode ensureInit() {
            CompilerAsserts.neverPartOfCompilation();
            InlinedFieldAccessNode bodyNode = this.body;
            if (bodyNode == null) {
                FieldAccessRecipes fieldAccessRecipes = this;
                synchronized (fieldAccessRecipes) {
                    bodyNode = this.body;
                    if (bodyNode == null) {
                        bodyNode = this.body = this.supplier.get();
                    }
                }
            }
            return bodyNode;
        }
    }
}

