/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.interop;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class Utils {
    public static boolean isBufferLike(InteropLibrary interop, Object foreignObject) {
        assert (!(foreignObject instanceof StaticObject));
        return interop.hasBufferElements(foreignObject);
    }

    public static boolean isArrayLike(InteropLibrary interop, Object foreignObject) {
        assert (!(foreignObject instanceof StaticObject));
        return interop.hasArrayElements(foreignObject);
    }

    public static boolean isByteArray(Meta meta, StaticObject array) {
        return array.getKlass() == meta._byte_array;
    }

    public static boolean isBufferLikeByteArray(EspressoLanguage language, Meta meta, InteropLibrary interop, StaticObject array) {
        assert (!StaticObject.isNull(array));
        assert (array.isForeignObject());
        return Utils.isByteArray(meta, array) && Utils.isBufferLike(interop, array.rawForeignObject(language));
    }
}

