/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.interop;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.bytecodes.LongArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.LongArrayStoreNodeGen;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class LongArrayStoreQuickNode
extends QuickNode {
    static final int stackEffectOf_LASTORE = Bytecodes.stackEffectOf(80);
    @Node.Child
    LongArrayStore.WithoutNullCheck longArrayStore = LongArrayStoreNodeGen.WithoutNullCheckNodeGen.create();

    public LongArrayStoreQuickNode(int top, int callerBCI) {
        super(top, callerBCI);
    }

    @Override
    public int execute(VirtualFrame frame) {
        long value = EspressoFrame.popLong((Frame)frame, this.top - 1);
        int index = EspressoFrame.popInt((Frame)frame, this.top - 3);
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, this.top - 4));
        this.longArrayStore.execute(array, index, value);
        return stackEffectOf_LASTORE;
    }
}

