/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class ForeignArrayUtils {
    private ForeignArrayUtils() {
        throw EspressoError.shouldNotReachHere("Must not instantiate the utils class");
    }

    public static Object readForeignArrayElement(StaticObject array, int index, EspressoLanguage language, Meta meta, InteropLibrary interop, BranchProfile exceptionProfile) {
        assert (array.isForeignObject());
        assert (interop.hasArrayElements(array.rawForeignObject(language)));
        try {
            return interop.readArrayElement(array.rawForeignObject(language), (long)index);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("readArrayElement on a non-array foreign object", e);
        }
        catch (InvalidArrayIndexException e) {
            exceptionProfile.enter();
            throw meta.throwExceptionWithMessage(meta.getMeta().java_lang_ArrayIndexOutOfBoundsException, e.getMessage());
        }
    }

    public static void writeForeignArrayElement(StaticObject array, int index, Object value, EspressoLanguage language, Meta meta, InteropLibrary interop, BranchProfile exceptionProfile) {
        assert (array.isForeignObject());
        assert (interop.hasArrayElements(array.rawForeignObject(language)));
        try {
            interop.writeArrayElement(array.rawForeignObject(language), (long)index, value);
        }
        catch (UnsupportedMessageException e) {
            exceptionProfile.enter();
            throw meta.throwExceptionWithMessage(meta.java_lang_ArrayStoreException, e.getMessage());
        }
        catch (UnsupportedTypeException e) {
            exceptionProfile.enter();
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, ForeignArrayUtils.createTypeErrorMessage(value));
        }
        catch (InvalidArrayIndexException e) {
            exceptionProfile.enter();
            throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, e.getMessage());
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String createTypeErrorMessage(Object value) {
        return "Could not cast the value " + String.valueOf(value) + " to the type of the foreign array elements";
    }
}

