/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.methodhandle;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.methodhandle.MethodHandleIntrinsicNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public abstract class MHInvokeBasicNode
extends MethodHandleIntrinsicNode {
    private final Field form;
    private final Field vmentry;
    private final Field hiddenVmtarget;
    static final int INLINE_CACHE_SIZE_LIMIT = 5;

    protected abstract Object executeCall(Object[] var1, Method var2);

    public static boolean canInline(Method target, Method cachedTarget) {
        return target.identity() == cachedTarget.identity();
    }

    private void sanitizeSignature(Method payload) {
        if (payload.getArgumentCount() != this.getMethod().getArgumentCount()) {
            this.getMeta().throwException(this.getMeta().java_lang_UnsupportedOperationException);
        }
    }

    @Specialization(limit="INLINE_CACHE_SIZE_LIMIT", guards={"inliningEnabled()", "canInline(target, cachedTarget)"})
    Object doCallDirect(Object[] args, Method target, @Cached(value="target") Method cachedTarget, @Cached(value="create(target.getCallTarget())") DirectCallNode directCallNode) {
        this.sanitizeSignature(cachedTarget);
        return directCallNode.call(args);
    }

    @Specialization(replaces={"doCallDirect"})
    Object doCallIndirect(Object[] args, Method target, @Cached(value="create()") IndirectCallNode callNode) {
        this.sanitizeSignature(target);
        return callNode.call(target.getCallTarget(), args);
    }

    public MHInvokeBasicNode(Method method) {
        super(method);
        Meta meta = method.getMeta();
        this.form = meta.java_lang_invoke_MethodHandle_form;
        this.vmentry = meta.java_lang_invoke_LambdaForm_vmentry;
        this.hiddenVmtarget = meta.HIDDEN_VMTARGET;
    }

    @Override
    public Object call(Object[] args) {
        StaticObject mh = (StaticObject)args[0];
        StaticObject lform = this.form.getObject(mh);
        StaticObject mname = this.vmentry.getObject(lform);
        Method target = (Method)this.hiddenVmtarget.getHiddenObject(mname);
        return this.executeCall(args, target);
    }
}

