/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.PrimitiveKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.CandidateMethodWithArgs;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.Arrays;

public class MethodArgsUtils {
    @CompilerDirectives.TruffleBoundary
    public static CandidateMethodWithArgs matchCandidate(Method candidate, Object[] arguments, Klass[] parameterKlasses, ToEspressoNode.DynamicToEspresso toEspressoNode) {
        boolean canConvert = true;
        int paramLength = parameterKlasses.length;
        Object[] convertedArgs = new Object[arguments.length];
        for (int j = 0; j < arguments.length; ++j) {
            Klass paramType = null;
            Object argument = arguments[j];
            boolean checkNeeded = true;
            try {
                if (candidate.isVarargs() && j >= paramLength - 1) {
                    paramType = ((ArrayKlass)parameterKlasses[paramLength - 1]).getComponentType();
                    InteropLibrary library = InteropLibrary.getUncached();
                    if (arguments.length == paramLength && j == paramLength - 1) {
                        if (library.hasArrayElements(argument)) {
                            long arraySize = library.getArraySize(argument);
                            if (arraySize >= Integer.MAX_VALUE) {
                                canConvert = false;
                                break;
                            }
                            convertedArgs = Arrays.copyOf(convertedArgs, convertedArgs.length + (int)arraySize - 1);
                            int l = 0;
                            while ((long)l < arraySize) {
                                if (!library.isArrayElementReadable(argument, (long)l)) {
                                    canConvert = false;
                                    break;
                                }
                                Object element = library.readArrayElement(argument, (long)l);
                                convertedArgs[j + l] = toEspressoNode.execute(element, paramType);
                                ++l;
                            }
                            checkNeeded = false;
                        } else if (library.isNull(argument)) {
                            convertedArgs[j] = StaticObject.NULL;
                            checkNeeded = false;
                        }
                    }
                }
                if (!checkNeeded) continue;
                if (paramType == null) {
                    paramType = parameterKlasses[j];
                }
                convertedArgs[j] = toEspressoNode.execute(argument, paramType);
                continue;
            }
            catch (UnsupportedTypeException e) {
                canConvert = false;
                continue;
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw EspressoError.shouldNotReachHere();
            }
        }
        return canConvert ? new CandidateMethodWithArgs(candidate, convertedArgs, parameterKlasses) : null;
    }

    @CompilerDirectives.TruffleBoundary
    public static CandidateMethodWithArgs ensureVarArgsArrayCreated(CandidateMethodWithArgs matched) {
        int varArgsIndex = matched.getParameterTypes().length - 1;
        Klass varArgsArrayType = matched.getParameterTypes()[varArgsIndex];
        Klass varArgsType = ((ArrayKlass)varArgsArrayType).getComponentType();
        boolean isPrimitive = varArgsType.isPrimitive();
        int varArgsLength = matched.getConvertedArgs().length - matched.getParameterTypes().length + 1;
        if (varArgsLength == 1 && matched.getConvertedArgs()[varArgsIndex] == StaticObject.NULL) {
            return matched;
        }
        StaticObject varArgsArray = isPrimitive ? varArgsType.getAllocator().createNewPrimitiveArray(varArgsType, varArgsLength) : varArgsType.allocateReferenceArray(varArgsLength);
        int index = 0;
        for (int i = varArgsIndex; i < matched.getConvertedArgs().length; ++i) {
            Object convertedArg = matched.getConvertedArgs()[i];
            if (!isPrimitive) {
                Object[] array = (Object[])varArgsArray.unwrap(matched.getMethod().getLanguage());
                array[index++] = convertedArg;
                continue;
            }
            MethodArgsUtils.putPrimitiveArg(varArgsArray, convertedArg, index, matched.getMethod().getLanguage());
            ++index;
        }
        Object[] finalConvertedArgs = new Object[matched.getParameterTypes().length];
        System.arraycopy(matched.getConvertedArgs(), 0, finalConvertedArgs, 0, varArgsIndex);
        finalConvertedArgs[varArgsIndex] = varArgsArray;
        return new CandidateMethodWithArgs(matched.getMethod(), finalConvertedArgs, matched.getParameterTypes());
    }

    public static PrimitiveKlass boxedTypeToPrimitiveType(Klass primitiveType) {
        Meta meta = primitiveType.getMeta();
        if (primitiveType == meta.java_lang_Boolean) {
            return meta._boolean;
        }
        if (primitiveType == meta.java_lang_Byte) {
            return meta._byte;
        }
        if (primitiveType == meta.java_lang_Short) {
            return meta._short;
        }
        if (primitiveType == meta.java_lang_Character) {
            return meta._char;
        }
        if (primitiveType == meta.java_lang_Integer) {
            return meta._int;
        }
        if (primitiveType == meta.java_lang_Long) {
            return meta._long;
        }
        if (primitiveType == meta.java_lang_Float) {
            return meta._float;
        }
        if (primitiveType == meta.java_lang_Double) {
            return meta._double;
        }
        return null;
    }

    public static Klass primitiveTypeToBoxedType(PrimitiveKlass primitiveType) {
        Meta meta = primitiveType.getMeta();
        switch (primitiveType.getPrimitiveJavaKind()) {
            case Int: {
                return meta.java_lang_Integer;
            }
            case Boolean: {
                return meta.java_lang_Boolean;
            }
            case Char: {
                return meta.java_lang_Character;
            }
            case Short: {
                return meta.java_lang_Short;
            }
            case Byte: {
                return meta.java_lang_Byte;
            }
            case Long: {
                return meta.java_lang_Long;
            }
            case Double: {
                return meta.java_lang_Double;
            }
            case Float: {
                return meta.java_lang_Float;
            }
            case Void: {
                return meta.java_lang_Void;
            }
        }
        return null;
    }

    static boolean isWideningPrimitiveConversion(Klass toType, Klass fromType) {
        assert (toType.isPrimitive());
        Meta meta = toType.getMeta();
        if (fromType == meta._byte) {
            return toType == meta._short || toType == meta._int || toType == meta._long || toType == meta._float || toType == meta._double;
        }
        if (fromType == meta._short) {
            return toType == meta._int || toType == meta._long || toType == meta._float || toType == meta._double;
        }
        if (fromType == meta._char) {
            return toType == meta._int || toType == meta._long || toType == meta._float || toType == meta._double;
        }
        if (fromType == meta._int) {
            return toType == meta._long || toType == meta._float || toType == meta._double;
        }
        if (fromType == meta._long) {
            return toType == meta._float || toType == meta._double;
        }
        if (fromType == meta._float) {
            return toType == meta._double;
        }
        return false;
    }

    private static void putPrimitiveArg(StaticObject varArgsArray, Object arg, int index, EspressoLanguage language) {
        Klass klass = varArgsArray.getKlass();
        Meta meta = klass.getMeta();
        if (klass == meta._boolean_array) {
            boolean[] array = (boolean[])varArgsArray.unwrap(language);
            array[index] = (Boolean)arg;
        } else if (klass == meta._int_array) {
            int[] array = (int[])varArgsArray.unwrap(language);
            array[index] = (Integer)arg;
        } else if (klass == meta._long_array) {
            long[] array = (long[])varArgsArray.unwrap(language);
            array[index] = (Long)arg;
        } else if (klass == meta._double_array) {
            double[] array = (double[])varArgsArray.unwrap(language);
            array[index] = (Double)arg;
        } else if (klass == meta._float_array) {
            float[] array = (float[])varArgsArray.unwrap(language);
            array[index] = ((Float)arg).floatValue();
        } else if (klass == meta._short_array) {
            short[] array = (short[])varArgsArray.unwrap(language);
            array[index] = (Short)arg;
        } else if (klass == meta._byte_array) {
            byte[] array = (byte[])varArgsArray.unwrap(language);
            array[index] = (Byte)arg;
        } else if (klass == meta._char_array) {
            char[] array = (char[])varArgsArray.unwrap(language);
            array[index] = ((Character)arg).charValue();
        }
    }
}

