/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.nodes.EspressoNode;

@GenerateUncached
public abstract class LookupFieldNode
extends EspressoNode {
    static final int LIMIT = 3;

    LookupFieldNode() {
    }

    public abstract Field execute(Klass var1, String var2, boolean var3);

    @Specialization(guards={"onlyStatic == cachedStatic", "klass == cachedKlass", "cachedName.equals(name)"}, limit="LIMIT")
    Field doCached(Klass klass, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="klass") Klass cachedKlass, @Cached(value="name") String cachedName, @Cached(value="doUncached(klass, name, onlyStatic)") Field cachedField) {
        assert (cachedField == this.doUncached(klass, name, onlyStatic));
        return cachedField;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(replaces={"doCached"})
    Field doUncached(Klass klass, String name, boolean onlyStatic) {
        for (Field f : klass.getDeclaredFields()) {
            if (!f.isPublic() || onlyStatic && !f.isStatic() || !name.equals(f.getNameAsString())) continue;
            return f;
        }
        return null;
    }
}

