/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.nodes.interop.LookupDeclaredMethod;
import java.lang.invoke.MethodHandles;

@GeneratedBy(value=LookupDeclaredMethod.class)
public final class LookupDeclaredMethodNodeGen
extends LookupDeclaredMethod {
    static final InlineSupport.ReferenceField<CachedData> CACHED_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"cached_cache", CachedData.class);
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    @InlineSupport.UnsafeAccessedField
    private CachedData cached_cache;

    private LookupDeclaredMethodNodeGen() {
    }

    @Override
    @ExplodeLoop
    public Method[] execute(Klass arg0Value, String arg1Value, boolean arg2Value, boolean arg3Value, int arg4Value) throws ArityException {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && arg0Value instanceof ObjectKlass) {
                ObjectKlass arg0Value_ = (ObjectKlass)arg0Value;
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if (!Assumption.isValidAssumption((Assumption)s0_.assumption0_)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.removeCached_(s0_);
                        return this.executeAndSpecialize(arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                    if (arg0Value_.equals(s0_.cachedKlass_.getKlass()) && arg1Value.equals(s0_.cachedMethodName_) && arg2Value == s0_.cachedPublicOnly_ && arg3Value == s0_.cachedIsStatic_ && arg4Value == s0_.cachedArity_) {
                        assert (DSLSupport.assertIdempotence((s0_.method_ != null ? 1 : 0) != 0));
                        return this.doCached(arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedKlass_, s0_.cachedMethodName_, s0_.cachedPublicOnly_, s0_.cachedIsStatic_, s0_.cachedArity_, s0_.method_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                return this.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    private Method[] executeAndSpecialize(Klass arg0Value, String arg1Value, boolean arg2Value, boolean arg3Value, int arg4Value) throws ArityException {
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0 && arg0Value instanceof ObjectKlass) {
            CachedData s0_;
            ObjectKlass arg0Value_;
            block6: {
                CachedData s0_original;
                arg0Value_ = (ObjectKlass)arg0Value;
                do {
                    Assumption assumption0;
                    Method[] method__;
                    ObjectKlass.KlassVersion cachedKlass__;
                    int count0_ = 0;
                    s0_original = s0_ = (CachedData)CACHED_CACHE_UPDATER.getVolatile((Node)this);
                    while (s0_ != null) {
                        if (arg0Value_.equals(s0_.cachedKlass_.getKlass()) && arg1Value.equals(s0_.cachedMethodName_) && arg2Value == s0_.cachedPublicOnly_ && arg3Value == s0_.cachedIsStatic_ && arg4Value == s0_.cachedArity_) {
                            assert (DSLSupport.assertIdempotence((s0_.method_ != null ? 1 : 0) != 0));
                            if (Assumption.isValidAssumption((Assumption)s0_.assumption0_)) break;
                        }
                        ++count0_;
                        s0_ = s0_.next_;
                    }
                    if (s0_ != null || !arg0Value_.equals((cachedKlass__ = arg0Value_.getKlassVersion()).getKlass()) || (method__ = this.doGeneric(arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value)) == null || !Assumption.isValidAssumption((Assumption)(assumption0 = cachedKlass__.getAssumption())) || count0_ >= 2) break block6;
                    s0_ = new CachedData(s0_original);
                    s0_.cachedKlass_ = cachedKlass__;
                    s0_.cachedMethodName_ = arg1Value;
                    s0_.cachedPublicOnly_ = arg2Value;
                    s0_.cachedIsStatic_ = arg3Value;
                    s0_.cachedArity_ = arg4Value;
                    s0_.method_ = method__;
                    s0_.assumption0_ = assumption0;
                } while (!CACHED_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                this.state_0_ = state_0 |= 1;
            }
            if (s0_ != null) {
                return this.doCached(arg0Value_, arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedKlass_, s0_.cachedMethodName_, s0_.cachedPublicOnly_, s0_.cachedIsStatic_, s0_.cachedArity_, s0_.method_);
            }
        }
        this.cached_cache = null;
        state_0 &= 0xFFFFFFFE;
        this.state_0_ = state_0 |= 2;
        return this.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    public NodeCost getCost() {
        CachedData s0_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.cached_cache) == null || s0_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    void removeCached_(CachedData s0_) {
        CachedData update;
        CachedData original;
        CachedData cur;
        block0: do {
            original = cur = this.cached_cache;
            update = null;
            while (cur != null) {
                if (cur == s0_) {
                    if (cur == original) {
                        update = cur.next_;
                        continue block0;
                    }
                    update = original.remove(s0_);
                    continue block0;
                }
                cur = cur.next_;
            }
        } while (cur != null && !CACHED_CACHE_UPDATER.compareAndSet((Node)this, (Object)original, update));
    }

    @NeverDefault
    public static LookupDeclaredMethod create() {
        return new LookupDeclaredMethodNodeGen();
    }

    @NeverDefault
    public static LookupDeclaredMethod getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LookupDeclaredMethod.class)
    @DenyReplace
    private static final class CachedData
    implements DSLSupport.SpecializationDataNode {
        @CompilerDirectives.CompilationFinal
        final CachedData next_;
        @CompilerDirectives.CompilationFinal
        ObjectKlass.KlassVersion cachedKlass_;
        @CompilerDirectives.CompilationFinal
        String cachedMethodName_;
        @CompilerDirectives.CompilationFinal
        boolean cachedPublicOnly_;
        @CompilerDirectives.CompilationFinal
        boolean cachedIsStatic_;
        @CompilerDirectives.CompilationFinal
        int cachedArity_;
        @CompilerDirectives.CompilationFinal(dimensions=0)
        Method[] method_;
        @CompilerDirectives.CompilationFinal
        Assumption assumption0_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        CachedData remove(CachedData search) {
            CachedData newNext = this.next_;
            if (newNext != null) {
                newNext = search == newNext ? newNext.next_ : newNext.remove(search);
            }
            CachedData copy = new CachedData(newNext);
            copy.cachedKlass_ = this.cachedKlass_;
            copy.cachedMethodName_ = this.cachedMethodName_;
            copy.cachedPublicOnly_ = this.cachedPublicOnly_;
            copy.cachedIsStatic_ = this.cachedIsStatic_;
            copy.cachedArity_ = this.cachedArity_;
            copy.method_ = this.method_;
            copy.assumption0_ = this.assumption0_;
            return copy;
        }
    }

    @GeneratedBy(value=LookupDeclaredMethod.class)
    @DenyReplace
    private static final class Uncached
    extends LookupDeclaredMethod {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Method[] execute(Klass arg0Value, String arg1Value, boolean arg2Value, boolean arg3Value, int arg4Value) throws ArityException {
            return this.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

